/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.NamingException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.realm.ldap.AbstractLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.connector.dao.NoLdapUserRolesFoundException;
import org.sonatype.nexus.ldap.internal.realms.LdapManager;
import org.sonatype.nexus.ldap.persist.LdapCacheInvalidatedEvent;

@Named(value="LdapRealm")
@Singleton
@Description(value="LDAP Realm")
public class LdapRealm
extends AbstractLdapRealm {
    private final Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass());
    private final LdapManager ldapManager;

    @Inject
    public LdapRealm(EventManager eventManager, LdapManager ldapManager) {
        this.ldapManager = (LdapManager)Preconditions.checkNotNull((Object)ldapManager);
        this.setName("LdapRealm");
        this.setAuthenticationCachingEnabled(false);
        this.setAuthorizationCachingEnabled(true);
        this.setCredentialsMatcher((CredentialsMatcher)new SimpleCredentialsMatcher());
        eventManager.register((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(LdapCacheInvalidatedEvent evt) {
        this.clearIfNonNull(this.getAuthenticationCache());
        this.clearIfNonNull(this.getAuthorizationCache());
    }

    protected void clearIfNonNull(@Nullable Cache<?, ?> cache) {
        if (cache != null) {
            cache.clear();
        }
    }

    protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        String pass = String.valueOf(upToken.getPassword());
        if (Strings.isNullOrEmpty((String)pass)) {
            throw new AuthenticationException("Password must not be empty");
        }
        LdapUser user = this.ldapManager.authenticateUser(username, pass);
        return new SimpleAuthenticationInfo((Object)user.getUsername(), (Object)pass.toCharArray(), this.getName());
    }

    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        if (principals.getRealmNames().contains(this.getName())) {
            Set<Object> roles = new HashSet();
            String username = principals.getPrimaryPrincipal().toString();
            try {
                roles = this.ldapManager.getUserRoles(username);
            }
            catch (LdapDAOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new NamingException(e.getMessage());
            }
            catch (NoLdapUserRolesFoundException e) {
                this.logger.debug("User: " + username + " does not have any ldap roles.", (Throwable)e);
            }
            return new SimpleAuthorizationInfo(roles);
        }
        return null;
    }
}

