/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.ldap.internal.connector.LdapConnector;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.connector.dao.NoLdapUserRolesFoundException;
import org.sonatype.nexus.ldap.internal.connector.dao.NoSuchLdapGroupException;
import org.sonatype.nexus.ldap.internal.connector.dao.NoSuchLdapUserException;

public class FailoverLdapConnector
implements LdapConnector {
    private static Logger log = LoggerFactory.getLogger(FailoverLdapConnector.class);
    private final LdapConnector originalLdapManagerConnector;
    private final LdapConnector backupLdapManagerConnector;
    private final int retryDelay;
    private final int maxIncidentsCount;
    private long connectionFailedTime = 0L;
    private int incidents = 0;

    public FailoverLdapConnector(LdapConnector originalLdapManagerConnector, @Nullable LdapConnector backupLdapManagerConnector, int retryDelaySeconds, int maxIncidentsCount) {
        this.originalLdapManagerConnector = (LdapConnector)Preconditions.checkNotNull((Object)originalLdapManagerConnector);
        this.backupLdapManagerConnector = backupLdapManagerConnector;
        this.retryDelay = retryDelaySeconds * 1000;
        this.maxIncidentsCount = maxIncidentsCount;
    }

    @VisibleForTesting
    void connectionFailed() {
        this.connectionFailedTime = System.currentTimeMillis();
        ++this.incidents;
    }

    @VisibleForTesting
    void resetFailure() {
        this.connectionFailedTime = 0L;
        this.incidents = 0;
    }

    @VisibleForTesting
    void setConnectionFailedTime(long connectionFailedTime) {
        this.connectionFailedTime = connectionFailedTime;
    }

    @VisibleForTesting
    boolean isOriginalConnectorValid() {
        if (this.connectionFailedTime == 0L) {
            log.debug("isOriginalConnectorValid=TRUE connectionFailedTime=={}", (Object)this.connectionFailedTime);
            return true;
        }
        if (this.connectionFailedTime + (long)this.retryDelay < System.currentTimeMillis()) {
            log.debug("isOriginalConnectorValid=TRUE {}+{} < {}", new Object[]{this.connectionFailedTime, this.retryDelay, System.currentTimeMillis()});
            this.resetFailure();
            return true;
        }
        if (this.incidents < this.maxIncidentsCount) {
            log.debug("isOriginalConnectorValid=TRUE {} < {}", (Object)this.incidents, (Object)this.maxIncidentsCount);
            return true;
        }
        return false;
    }

    @Override
    public SortedSet<String> getAllGroups() throws LdapDAOException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.getAllGroups();
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).getAllGroups();
            }
        }
        return this.getBackupConnector().getAllGroups();
    }

    @Override
    public SortedSet<LdapUser> getAllUsers() throws LdapDAOException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.getAllUsers();
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).getAllUsers();
            }
        }
        return this.getBackupConnector().getAllUsers();
    }

    @Override
    public String getGroupName(String groupId) throws LdapDAOException, NoSuchLdapGroupException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.getGroupName(groupId);
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).getGroupName(groupId);
            }
        }
        return this.getBackupConnector().getGroupName(groupId);
    }

    @Override
    public LdapUser getUser(String username) throws NoSuchLdapUserException, LdapDAOException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.getUser(username);
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).getUser(username);
            }
        }
        return this.getBackupConnector().getUser(username);
    }

    @Override
    public Set<String> getUserRoles(String userId) throws LdapDAOException, NoLdapUserRolesFoundException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.getUserRoles(userId);
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).getUserRoles(userId);
            }
        }
        return this.getBackupConnector().getUserRoles(userId);
    }

    @Override
    public SortedSet<LdapUser> getUsers(int userCount) throws LdapDAOException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.getUsers(userCount);
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).getUsers(userCount);
            }
        }
        return this.getBackupConnector().getUsers(userCount);
    }

    public SortedSet<LdapUser> searchUsers(String username, Set<String> roleIds) throws LdapDAOException {
        return this.searchUsers(username, roleIds, -1);
    }

    @Override
    public SortedSet<LdapUser> searchUsers(String username, Set<String> roleIds, int userCount) throws LdapDAOException {
        if (this.isOriginalConnectorValid()) {
            try {
                return this.originalLdapManagerConnector.searchUsers(username, roleIds, userCount);
            }
            catch (LdapDAOException e) {
                return this.getBackupConnector(e).searchUsers(username, roleIds, userCount);
            }
        }
        return this.getBackupConnector().searchUsers(username, roleIds, userCount);
    }

    @Override
    public String getIdentifier() {
        return this.originalLdapManagerConnector.getIdentifier();
    }

    @Override
    public LdapContextFactory getLdapContextFactory() throws LdapDAOException {
        if (this.isOriginalConnectorValid()) {
            return this.originalLdapManagerConnector.getLdapContextFactory();
        }
        return this.getBackupConnector().getLdapContextFactory();
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    private LdapConnector getBackupConnector(LdapDAOException exception) throws LdapDAOException {
        this.connectionFailed();
        if (this.backupLdapManagerConnector == null) {
            if (log.isDebugEnabled()) {
                log.warn("Problem connecting to LDAP server: {}", (Object)FailoverLdapConnector.mapToLogString(exception), (Object)exception);
            } else {
                log.warn("Problem connecting to LDAP server: {} {}", (Object)exception.toString(), (Object)FailoverLdapConnector.mapToLogString(exception));
            }
            throw exception;
        }
        if (log.isDebugEnabled()) {
            log.warn("Problem connecting to primary LDAP server, using backup connector. {}", (Object)FailoverLdapConnector.mapToLogString(exception), (Object)exception);
        } else {
            log.warn("Problem connecting to primary LDAP server, using backup connector ({}) {}", (Object)exception.toString(), (Object)FailoverLdapConnector.mapToLogString(exception));
        }
        return this.backupLdapManagerConnector;
    }

    private LdapConnector getBackupConnector() throws LdapDAOException {
        if (this.backupLdapManagerConnector == null) {
            throw new LdapDAOException("Waiting for connection retry timeout.");
        }
        return this.backupLdapManagerConnector;
    }

    @VisibleForTesting
    static String mapToLogString(LdapDAOException e) {
        int depthLimit = 3;
        StringBuilder builder = new StringBuilder();
        Throwable cause = e;
        while ((cause = cause.getCause()) != null && depthLimit-- >= 0) {
            builder.append(" Caused by: ").append(cause.toString());
        }
        return builder.toString();
    }
}

