/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao;

import com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapAuthConfiguration;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUserDAO;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUtils;
import org.sonatype.nexus.ldap.internal.connector.dao.NoSuchLdapUserException;

@Singleton
@Named
public class DefaultLdapUserDAO
extends ComponentSupport
implements LdapUserDAO {
    @Override
    public NamingEnumeration<SearchResult> searchUsers(String username, LdapContext context, LdapAuthConfiguration configuration, long limitCount, boolean wildcardSearch) throws NamingException {
        String[] userAttributes = configuration.getUserAttributes();
        SearchControls ctls = new SearchControls();
        ctls.setDerefLinkFlag(true);
        ctls.setSearchScope(configuration.isUserSubtree() ? 2 : 1);
        ctls.setReturningAttributes(userAttributes);
        if (limitCount > 0L) {
            ctls.setCountLimit(limitCount);
        }
        String f = configuration.getLdapFilter();
        this.log.debug("Specific filter rule: \"" + (f != null ? f : "none") + "\"");
        String filter = "(&(objectClass=" + configuration.getUserObjectClass() + ")(" + configuration.getUserIdAttribute() + "=" + (username != null ? LdapUtils.encode(username, wildcardSearch) : "*") + ")" + (f != null && !f.isEmpty() ? "(" + f + ")" : "") + ")";
        this.log.debug("Searching for users with filter: '" + filter + "'");
        String baseDN = Strings.nullToEmpty((String)configuration.getUserBaseDn());
        return context.search(baseDN, filter, ctls);
    }

    @Override
    public SortedSet<LdapUser> getAllUsers(LdapContext context, LdapAuthConfiguration configuration, long limitCount) throws LdapDAOException {
        return this.getUsers(null, context, configuration, limitCount);
    }

    @Override
    public SortedSet<LdapUser> getUsers(String username, LdapContext context, LdapAuthConfiguration configuration, long limitCount) throws LdapDAOException {
        TreeSet<LdapUser> treeSet;
        NamingEnumeration<SearchResult> results = this.searchUsers(username, context, configuration, limitCount, true);
        try {
            TreeSet<LdapUser> users = new TreeSet<LdapUser>();
            while (results.hasMoreElements()) {
                SearchResult result = (SearchResult)results.nextElement();
                users.add(this.createUser(result, configuration));
            }
            treeSet = users;
        }
        catch (Throwable throwable) {
            try {
                results.close();
                throw throwable;
            }
            catch (NamingException e) {
                String message = "Failed to retrieve ldap information for users.";
                throw new LdapDAOException(message, e);
            }
        }
        results.close();
        return treeSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LdapUser getUser(String username, LdapContext context, LdapAuthConfiguration configuration) throws NoSuchLdapUserException, LdapDAOException {
        this.log.debug("Searching for user: " + username);
        try (NamingEnumeration<SearchResult> result = this.searchUsers(username, context, configuration, 1L, false);){
            if (!result.hasMoreElements()) throw new NoSuchLdapUserException("A user with username '" + username + "' does not exist");
            LdapUser ldapUser = this.createUser((SearchResult)result.nextElement(), configuration);
            return ldapUser;
        }
        catch (NamingException e) {
            String message = "Failed to retrieve information for user: " + username;
            throw new LdapDAOException(message, e);
        }
    }

    private LdapUser createUser(SearchResult result, LdapAuthConfiguration configuration) throws LdapDAOException {
        Attributes attributes = result.getAttributes();
        LdapUser user = new LdapUser();
        String userIdAttribute = configuration.getUserIdAttribute();
        String emailAddressAttribute = configuration.getEmailAddressAttribute();
        String nameAttribute = configuration.getUserRealNameAttribute();
        String websiteAttribute = configuration.getWebsiteAttribute();
        String websiteUriLabel = configuration.getWebsiteUriLabel();
        String passwordAttribute = configuration.getPasswordAttribute();
        String memberOfAttribute = configuration.getUserMemberOfAttribute();
        user.setUsername(LdapUtils.getAttributeValue(attributes, userIdAttribute, "username"));
        user.setDn(result.getNameInNamespace());
        user.setEmail(LdapUtils.getAttributeValue(attributes, emailAddressAttribute, "email address"));
        user.setRealName(LdapUtils.getAttributeValue(attributes, nameAttribute, "name"));
        user.setPassword(LdapUtils.getAttributeValueFromByteArray(attributes, passwordAttribute, "password"));
        if (configuration.isWebsiteAttributeLabelUri()) {
            user.setWebsite(LdapUtils.getLabeledUriValue(attributes, websiteAttribute, websiteUriLabel, "website"));
        } else {
            user.setWebsite(LdapUtils.getAttributeValue(attributes, websiteAttribute, "website"));
        }
        if (configuration.isLdapGroupsAsRoles() && !Strings2.isEmpty((String)configuration.getUserMemberOfAttribute())) {
            Set<String> groups = LdapUtils.getAttributeValues(attributes, memberOfAttribute, "Member Of");
            HashSet<String> resolvedGroups = new HashSet<String>();
            for (String dnString : groups) {
                resolvedGroups.add(this.getGroupFromString(dnString));
            }
            user.setMembership(resolvedGroups);
        }
        return user;
    }

    private String getGroupFromString(String dnString) {
        String result = dnString;
        try {
            LdapName dn = new LdapName(dnString);
            result = String.valueOf(dn.getRdn(dn.size() - 1).getValue());
        }
        catch (InvalidNameException invalidNameException) {
            this.log.debug("Expected a Group DN but found: " + dnString);
        }
        return result;
    }
}

