/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.sonatype.nexus.common.text.Strings2;

public class LdapAuthConfiguration {
    public static final String DEFAULT_NAME_ATTRIBUTE = "sn";
    public static final String DEFAULT_USER_MEMBER_OF = "memberOf";
    public static final String DEFAULT_EMAIL_ADDRESS_ATTRIBUTE = "mail";
    public static final String DEFAULT_WEBSITE_ATTRIBUTE = "labeledUri";
    public static final String DEFAULT_WEB_URI_LABEL = "Web Site";
    private static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";
    private static final String DEFAULT_GROUP_ID_ATTRIBUTE = "cn";
    private static final String DEFAULT_USER_PASSWORD_ENCODING = "crypt";
    private static final String DEFAULT_USER_OBJECTCLASS = "inetOrgPerson";
    private static final String DEFAULT_GROUP_OBJECTCLASS = "groupOfNames";
    private Map<String, Set<String>> groupReverseMappings;
    private Map<String, String> groupMappings;
    private String groupMemberFormat;
    private String groupObjectClass = "groupOfNames";
    private String groupBaseDn;
    private String groupIdAttribute = "cn";
    private String groupMemberAttribute;
    private String userObjectClass = "inetOrgPerson";
    private String userBaseDn;
    private String userIdAttribute = "uid";
    private String passwordAttribute;
    private String userRealNameAttribute = "sn";
    private String userMemberOfAttribute = "memberOf";
    private String emailAddressAttribute = "mail";
    private String websiteAttribute = "labeledUri";
    private String websiteUriLabel = "Web Site";
    private boolean isWebsiteAttributeLabelUri = true;
    private String ldapFilter;
    private boolean ldapGroupsAsRoles;
    private boolean userSubtree;
    private boolean groupSubtree;

    public String getGroupBaseDn() {
        return this.groupBaseDn;
    }

    public void setGroupBaseDn(String groupBaseDn) {
        this.groupBaseDn = groupBaseDn;
    }

    public String getGroupIdAttribute() {
        return this.groupIdAttribute;
    }

    public void setGroupIdAttribute(String groupIdAttribute) {
        this.groupIdAttribute = groupIdAttribute;
    }

    public Map<String, String> getGroupMappings() {
        return this.groupMappings;
    }

    public synchronized void setGroupMappings(Map<String, String> groupMappings) {
        this.groupMappings = groupMappings;
        this.groupReverseMappings = null;
    }

    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    public synchronized Map<String, Set<String>> getGroupReverseMappings() {
        if (this.groupReverseMappings == null) {
            this.groupReverseMappings = new HashMap<String, Set<String>>();
            if (this.groupMappings != null) {
                for (Map.Entry<String, String> entry : this.groupMappings.entrySet()) {
                    String logical = entry.getKey();
                    String real = entry.getValue();
                    Set<String> logicalMappings = this.groupReverseMappings.get(real);
                    if (logicalMappings == null) {
                        logicalMappings = new LinkedHashSet<String>();
                        this.groupReverseMappings.put(real, logicalMappings);
                    }
                    logicalMappings.add(logical);
                }
            }
        }
        return this.groupReverseMappings;
    }

    public String getEmailAddressAttribute() {
        return this.emailAddressAttribute;
    }

    public void setEmailAddressAttribute(String emailAddressAttribute) {
        this.emailAddressAttribute = emailAddressAttribute;
    }

    public String getUserRealNameAttribute() {
        return this.userRealNameAttribute;
    }

    public void setUserRealNameAttribute(String nameAttribute) {
        this.userRealNameAttribute = nameAttribute;
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    public String getWebsiteAttribute() {
        return this.websiteAttribute;
    }

    public void setWebsiteAttribute(String websiteAttribute) {
        this.websiteAttribute = websiteAttribute;
    }

    public boolean isWebsiteAttributeLabelUri() {
        return this.isWebsiteAttributeLabelUri;
    }

    public void setWebsiteAttributeLabelUri(boolean websiteIsLabelUri) {
        this.isWebsiteAttributeLabelUri = websiteIsLabelUri;
    }

    public String getWebsiteUriLabel() {
        return this.websiteUriLabel;
    }

    public void setWebsiteUriLabel(String websiteUriLabel) {
        this.websiteUriLabel = websiteUriLabel;
    }

    public synchronized String[] getUserAttributes() {
        String[] allAttributes;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = allAttributes = new String[]{this.userIdAttribute, this.passwordAttribute, this.userRealNameAttribute, this.emailAddressAttribute, this.websiteAttribute, this.userMemberOfAttribute};
        int n = allAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!Strings2.isBlank((String)attribute)) {
                result.add(attribute);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public String getGroupMemberFormat() {
        return this.groupMemberFormat;
    }

    public void setGroupMemberFormat(String groupMemberFormat) {
        this.groupMemberFormat = groupMemberFormat;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public boolean isLdapGroupsAsRoles() {
        return this.ldapGroupsAsRoles;
    }

    public void setLdapGroupsAsRoles(boolean ldapGroupsAsRoles) {
        this.ldapGroupsAsRoles = ldapGroupsAsRoles;
    }

    public boolean isUserSubtree() {
        return this.userSubtree;
    }

    public void setUserSubtree(boolean userSubtree) {
        this.userSubtree = userSubtree;
    }

    public boolean isGroupSubtree() {
        return this.groupSubtree;
    }

    public void setGroupSubtree(boolean groupSubtree) {
        this.groupSubtree = groupSubtree;
    }

    public String getUserMemberOfAttribute() {
        return this.userMemberOfAttribute;
    }

    public void setUserMemberOfAttribute(String userMemberOfAttribute) {
        this.userMemberOfAttribute = userMemberOfAttribute;
    }

    public String getLdapFilter() {
        return this.ldapFilter;
    }

    public void setLdapFilter(String ldapFilter) {
        this.ldapFilter = ldapFilter;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.emailAddressAttribute == null ? 0 : this.emailAddressAttribute.hashCode());
        result = 31 * result + (this.groupBaseDn == null ? 0 : this.groupBaseDn.hashCode());
        result = 31 * result + (this.groupIdAttribute == null ? 0 : this.groupIdAttribute.hashCode());
        result = 31 * result + (this.groupMappings == null ? 0 : this.groupMappings.hashCode());
        result = 31 * result + (this.groupMemberAttribute == null ? 0 : this.groupMemberAttribute.hashCode());
        result = 31 * result + (this.groupMemberFormat == null ? 0 : this.groupMemberFormat.hashCode());
        result = 31 * result + (this.groupObjectClass == null ? 0 : this.groupObjectClass.hashCode());
        result = 31 * result + (this.groupReverseMappings == null ? 0 : this.groupReverseMappings.hashCode());
        result = 31 * result + (this.groupSubtree ? 1231 : 1237);
        result = 31 * result + (this.isWebsiteAttributeLabelUri ? 1231 : 1237);
        result = 31 * result + (this.ldapGroupsAsRoles ? 1231 : 1237);
        result = 31 * result + (this.passwordAttribute == null ? 0 : this.passwordAttribute.hashCode());
        result = 31 * result + (this.userBaseDn == null ? 0 : this.userBaseDn.hashCode());
        result = 31 * result + (this.userIdAttribute == null ? 0 : this.userIdAttribute.hashCode());
        result = 31 * result + (this.userMemberOfAttribute == null ? 0 : this.userMemberOfAttribute.hashCode());
        result = 31 * result + (this.userObjectClass == null ? 0 : this.userObjectClass.hashCode());
        result = 31 * result + (this.userRealNameAttribute == null ? 0 : this.userRealNameAttribute.hashCode());
        result = 31 * result + (this.userSubtree ? 1231 : 1237);
        result = 31 * result + (this.websiteAttribute == null ? 0 : this.websiteAttribute.hashCode());
        result = 31 * result + (this.websiteUriLabel == null ? 0 : this.websiteUriLabel.hashCode());
        result = 31 * result + (this.ldapFilter == null ? 0 : this.ldapFilter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapAuthConfiguration other = (LdapAuthConfiguration)obj;
        if (this.emailAddressAttribute == null ? other.emailAddressAttribute != null : !this.emailAddressAttribute.equals(other.emailAddressAttribute)) {
            return false;
        }
        if (this.groupBaseDn == null ? other.groupBaseDn != null : !this.groupBaseDn.equals(other.groupBaseDn)) {
            return false;
        }
        if (this.groupIdAttribute == null ? other.groupIdAttribute != null : !this.groupIdAttribute.equals(other.groupIdAttribute)) {
            return false;
        }
        if (this.groupMappings == null ? other.groupMappings != null : !this.groupMappings.equals(other.groupMappings)) {
            return false;
        }
        if (this.groupMemberAttribute == null ? other.groupMemberAttribute != null : !this.groupMemberAttribute.equals(other.groupMemberAttribute)) {
            return false;
        }
        if (this.groupMemberFormat == null ? other.groupMemberFormat != null : !this.groupMemberFormat.equals(other.groupMemberFormat)) {
            return false;
        }
        if (this.groupObjectClass == null ? other.groupObjectClass != null : !this.groupObjectClass.equals(other.groupObjectClass)) {
            return false;
        }
        if (this.groupReverseMappings == null ? other.groupReverseMappings != null : !this.groupReverseMappings.equals(other.groupReverseMappings)) {
            return false;
        }
        if (this.groupSubtree != other.groupSubtree) {
            return false;
        }
        if (this.isWebsiteAttributeLabelUri != other.isWebsiteAttributeLabelUri) {
            return false;
        }
        if (this.ldapGroupsAsRoles != other.ldapGroupsAsRoles) {
            return false;
        }
        if (this.passwordAttribute == null ? other.passwordAttribute != null : !this.passwordAttribute.equals(other.passwordAttribute)) {
            return false;
        }
        if (this.userBaseDn == null ? other.userBaseDn != null : !this.userBaseDn.equals(other.userBaseDn)) {
            return false;
        }
        if (this.userIdAttribute == null ? other.userIdAttribute != null : !this.userIdAttribute.equals(other.userIdAttribute)) {
            return false;
        }
        if (this.userMemberOfAttribute == null ? other.userMemberOfAttribute != null : !this.userMemberOfAttribute.equals(other.userMemberOfAttribute)) {
            return false;
        }
        if (this.userObjectClass == null ? other.userObjectClass != null : !this.userObjectClass.equals(other.userObjectClass)) {
            return false;
        }
        if (this.userRealNameAttribute == null ? other.userRealNameAttribute != null : !this.userRealNameAttribute.equals(other.userRealNameAttribute)) {
            return false;
        }
        if (this.userSubtree != other.userSubtree) {
            return false;
        }
        if (this.websiteAttribute == null ? other.websiteAttribute != null : !this.websiteAttribute.equals(other.websiteAttribute)) {
            return false;
        }
        if (this.websiteUriLabel == null ? other.websiteUriLabel != null : !this.websiteUriLabel.equals(other.websiteUriLabel)) {
            return false;
        }
        return !(this.ldapFilter == null ? other.ldapFilter != null : !this.ldapFilter.equals(other.ldapFilter));
    }
}

