/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao;

public final class LdapEncoder {
    private static String[] NAME_ESCAPE_TABLE = new String[96];

    static {
        char c = '\u0000';
        while (c < ' ') {
            LdapEncoder.NAME_ESCAPE_TABLE[c] = "\\" + LdapEncoder.toTwoCharHex(c);
            c = (char)(c + '\u0001');
        }
        LdapEncoder.NAME_ESCAPE_TABLE[35] = "\\#";
        LdapEncoder.NAME_ESCAPE_TABLE[44] = "\\,";
        LdapEncoder.NAME_ESCAPE_TABLE[59] = "\\;";
        LdapEncoder.NAME_ESCAPE_TABLE[61] = "\\=";
        LdapEncoder.NAME_ESCAPE_TABLE[43] = "\\+";
        LdapEncoder.NAME_ESCAPE_TABLE[60] = "\\<";
        LdapEncoder.NAME_ESCAPE_TABLE[62] = "\\>";
        LdapEncoder.NAME_ESCAPE_TABLE[34] = "\\\"";
        LdapEncoder.NAME_ESCAPE_TABLE[92] = "\\\\";
    }

    private LdapEncoder() {
    }

    protected static String toTwoCharHex(char c) {
        String raw = Integer.toHexString(c).toUpperCase();
        if (raw.length() > 1) {
            return raw;
        }
        return "0" + raw;
    }

    public static String nameEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder encodedValue = new StringBuilder(value.length() * 2);
        int length = value.length();
        int last = length - 1;
        int i = 0;
        while (i < length) {
            String esc;
            char c = value.charAt(i);
            if (c == ' ' && (i == 0 || i == last)) {
                encodedValue.append("\\ ");
            } else if (c < NAME_ESCAPE_TABLE.length && (esc = NAME_ESCAPE_TABLE[c]) != null) {
                encodedValue.append(esc);
            } else {
                encodedValue.append(c);
            }
            ++i;
        }
        return encodedValue.toString();
    }
}

