/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapSearch;

public final class LdapUtils {
    private static final Map<Character, String> SEARCH_FILTER_ESCAPE_CHARS = ImmutableMap.builder().put((Object)Character.valueOf('*'), (Object)"\\2a").put((Object)Character.valueOf('('), (Object)"\\28").put((Object)Character.valueOf(')'), (Object)"\\29").put((Object)Character.valueOf('\\'), (Object)"\\5c").put((Object)Character.valueOf('\u0000'), (Object)"\\00").build();

    private LdapUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLabeledUriValue(Attributes attributes, String attrName, String label, String attributeDescription) throws LdapDAOException {
        Attribute attribute = attributes.get(attrName);
        if (attribute == null) return null;
        try (NamingEnumeration<?> attrs = attribute.getAll();){
            Object value;
            String val;
            do {
                if (attrs.hasMoreElements()) continue;
                return null;
            } while (!(val = String.valueOf(value = attrs.nextElement())).endsWith(" " + label));
            String string = val.substring(0, val.length() - (label.length() + 1));
            return string;
        }
        catch (NamingException e) {
            throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
        }
    }

    public static String getAttributeValue(Attributes attributes, String attrName, String attributeDescription) throws LdapDAOException {
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                Object value = attribute.get();
                return String.valueOf(value);
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return null;
    }

    public static Set<String> getAttributeValues(Attributes attributes, String attrName, String attributeDescription) throws LdapDAOException {
        HashSet<String> results = new HashSet<String>();
        Attribute attribute = attributes.get(attrName);
        if (attribute != null) {
            try {
                NamingEnumeration<?> values = attribute.getAll();
                while (values.hasMoreElements()) {
                    results.add(String.valueOf(values.nextElement()));
                }
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return results;
    }

    public static String getAttributeValueFromByteArray(Attributes attributes, String attrName, String attributeDescription) throws LdapDAOException {
        Attribute attribute;
        if (attrName != null && (attribute = attributes.get(attrName)) != null) {
            try {
                byte[] value = (byte[])attribute.get();
                return new String(value);
            }
            catch (NamingException e) {
                throw new LdapDAOException("Failed to retrieve " + attributeDescription + " (attribute: '" + attrName + "').", e);
            }
        }
        return null;
    }

    static List<SearchResult> pagedLdapSearch(LdapContext context, int pageSize, LdapSearch ldapSearch) throws IOException, NamingException {
        if (pageSize == -1) {
            return LdapUtils.nonPagedLdapSearch(ldapSearch);
        }
        Control[] originalControls = context.getRequestControls();
        byte[] cookie = null;
        context.setRequestControls(new Control[]{new PagedResultsControl(pageSize, false)});
        ArrayList results = Lists.newArrayList();
        do {
            try (NamingEnumeration<SearchResult> namingEnumeration = ldapSearch.search();){
                results.addAll(Collections.list(namingEnumeration));
                Control[] controls = context.getResponseControls();
                if (controls != null) {
                    Control[] controlArray = controls;
                    int n = controls.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof PagedResultsResponseControl) {
                            cookie = ((PagedResultsResponseControl)control).getCookie();
                        }
                        ++n2;
                    }
                }
                context.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
            }
        } while (cookie != null);
        context.setRequestControls(originalControls);
        return results;
    }

    private static List<SearchResult> nonPagedLdapSearch(LdapSearch ldapSearch) throws NamingException {
        try (NamingEnumeration<SearchResult> results = ldapSearch.search();){
            ArrayList<SearchResult> arrayList = Collections.list(results);
            return arrayList;
        }
    }

    static String encode(@Nonnull String searchFilter, boolean wildcardSearch) {
        StringBuilder encodedValue = new StringBuilder();
        int i = 0;
        while (i < searchFilter.length()) {
            char c = searchFilter.charAt(i);
            encodedValue.append(SEARCH_FILTER_ESCAPE_CHARS.getOrDefault(Character.valueOf(c), String.valueOf(c)));
            ++i;
        }
        if (wildcardSearch) {
            encodedValue.append("*");
        }
        return encodedValue.toString();
    }
}

