/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao.password;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ldap.internal.connector.dao.password.PasswordEncoder;

@Singleton
@Named(value="clear")
public class ClearTextPasswordEncoder
implements PasswordEncoder {
    @Override
    public String getMethod() {
        return "CLEAR";
    }

    @Override
    public String encodePassword(String password, Object salt) {
        return password;
    }

    @Override
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        String encryptedPassword = encPassword;
        if (encryptedPassword.startsWith("{CLEAR}") || encryptedPassword.startsWith("{clear}")) {
            encryptedPassword = encryptedPassword.substring("{clear}".length());
        }
        String check = this.encodePassword(inputPassword, salt);
        return check.equals(encryptedPassword);
    }
}

