/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.realms;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.connector.dao.password.PasswordEncoderManager;

@Singleton
@Named
public class LdapAuthenticator {
    private final PasswordEncoderManager passwordManager;

    @Inject
    public LdapAuthenticator(PasswordEncoderManager passwordManager) {
        this.passwordManager = (PasswordEncoderManager)Preconditions.checkNotNull((Object)passwordManager);
    }

    public void authenticateUserWithPassword(LdapUser ldapUser, String password) {
        if (!this.passwordManager.isPasswordValid(ldapUser.getPassword(), password, null)) {
            throw new org.apache.shiro.authc.AuthenticationException("User '" + ldapUser.getUsername() + "' cannot be authenticated.");
        }
    }

    public void authenticateUserWithBind(LdapUser ldapUser, String password, LdapContextFactory ldapContextFactory, String authScheme) {
        String userId = ldapUser.getUsername();
        String bindUsername = ldapUser.getDn();
        if ("DIGEST-MD5".equals(authScheme) || "CRAM-MD5".equals(authScheme)) {
            bindUsername = userId;
        }
        this.checkPasswordUsingBind(ldapContextFactory, bindUsername, password);
    }

    private void checkPasswordUsingBind(LdapContextFactory ldapContextFactory, String user, String pass) {
        LdapContext ctx = null;
        try {
            try {
                ctx = ldapContextFactory.getLdapContext(user, pass);
            }
            catch (AuthenticationException e) {
                throw new org.apache.shiro.authc.AuthenticationException("User '" + user + "' cannot be authenticated.", (Throwable)e);
            }
            catch (NamingException e) {
                throw new org.apache.shiro.authc.AuthenticationException("User '" + user + "' cannot be authenticated.", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            LdapUtils.closeContext(ctx);
            throw throwable;
        }
        LdapUtils.closeContext((LdapContext)ctx);
    }
}

