/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.realms;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.ldap.internal.LdapURL;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapAuthConfiguration;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.realms.DefaultLdapContextFactory;
import org.sonatype.nexus.ldap.internal.ssl.SSLLdapContextFactory;
import org.sonatype.nexus.ldap.persist.entity.Connection;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.entity.Mapping;
import org.sonatype.nexus.ssl.TrustStore;

public class LdapConnectionUtils {
    private static Logger log = LoggerFactory.getLogger(LdapConnectionUtils.class);

    private LdapConnectionUtils() {
    }

    public static LdapContextFactory getLdapContextFactory(LdapConfiguration configuration, TrustStore trustStore) throws LdapDAOException {
        String url;
        if (configuration == null) {
            throw new LdapDAOException("Ldap connection is not configured.");
        }
        DefaultLdapContextFactory defaultLdapContextFactory = new DefaultLdapContextFactory();
        Connection connInfo = configuration.getConnection();
        Connection.Host host = connInfo.getHost();
        try {
            url = new LdapURL(host.getProtocol().name(), host.getHostName(), host.getPort(), connInfo.getSearchBase()).toString();
        }
        catch (MalformedURLException e) {
            log.error("LDAP Configuration is Invalid.");
            throw new LdapDAOException("Invalid LDAP URL: " + e.getMessage());
        }
        defaultLdapContextFactory.setUsePooling(true);
        defaultLdapContextFactory.setUrl(url);
        defaultLdapContextFactory.setSystemUsername(connInfo.getSystemUsername());
        defaultLdapContextFactory.setSystemPassword(connInfo.getSystemPassword());
        defaultLdapContextFactory.setSearchBase(connInfo.getSearchBase());
        defaultLdapContextFactory.setAuthentication(connInfo.getAuthScheme());
        HashMap<String, String> connectionProperties = new HashMap<String, String>();
        connectionProperties.put("com.sun.jndi.ldap.connect.timeout", Integer.toString(connInfo.getConnectionTimeout() * 1000));
        if (connInfo.getSaslRealm() != null) {
            connectionProperties.put("java.naming.security.sasl.realm", connInfo.getSaslRealm());
        }
        defaultLdapContextFactory.addAdditionalEnvironment(connectionProperties);
        if (host.getProtocol() == Connection.Protocol.ldaps && connInfo.getUseTrustStore()) {
            SSLContext sslContext = trustStore.getSSLContext();
            log.debug("Using Nexus SSL truststore for accessing {}:{}", (Object)host.getHostName(), (Object)host.getPort());
            return new SSLLdapContextFactory(sslContext, defaultLdapContextFactory);
        }
        log.debug("Using JVM truststore for accessing {}:{}", (Object)host.getHostName(), (Object)host.getPort());
        return defaultLdapContextFactory;
    }

    public static LdapAuthConfiguration getLdapAuthConfiguration(LdapConfiguration ldapServer) {
        Mapping userAndGroupsConf = ldapServer.getMapping();
        LdapAuthConfiguration authConfig = new LdapAuthConfiguration();
        authConfig.setEmailAddressAttribute(userAndGroupsConf.getEmailAddressAttribute());
        authConfig.setUserBaseDn(Strings.nullToEmpty((String)userAndGroupsConf.getUserBaseDn()));
        authConfig.setUserIdAttribute(userAndGroupsConf.getUserIdAttribute());
        authConfig.setUserObjectClass(userAndGroupsConf.getUserObjectClass());
        authConfig.setPasswordAttribute(userAndGroupsConf.getUserPasswordAttribute());
        authConfig.setUserRealNameAttribute(userAndGroupsConf.getUserRealNameAttribute());
        authConfig.setGroupBaseDn(Strings.nullToEmpty((String)userAndGroupsConf.getGroupBaseDn()));
        authConfig.setGroupIdAttribute(userAndGroupsConf.getGroupIdAttribute());
        authConfig.setGroupMemberAttribute(userAndGroupsConf.getGroupMemberAttribute());
        authConfig.setGroupMemberFormat(userAndGroupsConf.getGroupMemberFormat());
        authConfig.setGroupObjectClass(userAndGroupsConf.getGroupObjectClass());
        authConfig.setUserSubtree(userAndGroupsConf.isUserSubtree());
        authConfig.setGroupSubtree(userAndGroupsConf.isGroupSubtree());
        authConfig.setUserMemberOfAttribute(userAndGroupsConf.getUserMemberOfAttribute());
        authConfig.setLdapGroupsAsRoles(userAndGroupsConf.isLdapGroupsAsRoles());
        authConfig.setLdapFilter(userAndGroupsConf.getLdapFilter());
        return authConfig;
    }
}

