/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.ssl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.net.ssl.SSLContext;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.sonatype.nexus.ldap.internal.realms.DefaultLdapContextFactory;
import org.sonatype.nexus.ldap.internal.ssl.ThreadLocalSocketFactory;

public class SSLLdapContextFactory
implements LdapContextFactory {
    private final SSLContext sslContext;
    private final DefaultLdapContextFactory delegate;

    public SSLLdapContextFactory(SSLContext sslContext, DefaultLdapContextFactory delegate) {
        this.sslContext = (SSLContext)Preconditions.checkNotNull((Object)sslContext);
        this.delegate = (DefaultLdapContextFactory)Preconditions.checkNotNull((Object)delegate);
        HashMap envProperties = Maps.newHashMap();
        envProperties.put("java.naming.ldap.factory.socket", ThreadLocalSocketFactory.class.getName());
        delegate.addAdditionalEnvironment(envProperties);
    }

    public LdapContext getSystemLdapContext() throws NamingException {
        ClassLoader backup = Thread.currentThread().getContextClassLoader();
        try {
            ThreadLocalSocketFactory.set(this.sslContext.getSocketFactory());
            Thread.currentThread().setContextClassLoader(ThreadLocalSocketFactory.class.getClassLoader());
            LdapContext ldapContext = this.delegate.getSystemLdapContext();
            return ldapContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(backup);
            ThreadLocalSocketFactory.remove();
        }
    }

    public LdapContext getLdapContext(String username, String password) throws NamingException {
        ClassLoader backup = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ThreadLocalSocketFactory.class.getClassLoader());
            ThreadLocalSocketFactory.set(this.sslContext.getSocketFactory());
            LdapContext ldapContext = this.delegate.getLdapContext(username, password);
            return ldapContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(backup);
            ThreadLocalSocketFactory.remove();
        }
    }

    public LdapContext getLdapContext(Object principal, Object credentials) throws NamingException {
        ClassLoader backup = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ThreadLocalSocketFactory.class.getClassLoader());
            ThreadLocalSocketFactory.set(this.sslContext.getSocketFactory());
            LdapContext ldapContext = this.delegate.getLdapContext(principal, credentials);
            return ldapContext;
        }
        finally {
            Thread.currentThread().setContextClassLoader(backup);
            ThreadLocalSocketFactory.remove();
        }
    }
}

