/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.ldap.internal.LdapURL;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapConnectionTester;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.realms.EnterpriseLdapManager;
import org.sonatype.nexus.ldap.internal.realms.LdapConnectionUtils;
import org.sonatype.nexus.ldap.internal.templates.LdapSchemaTemplate;
import org.sonatype.nexus.ldap.internal.templates.LdapSchemaTemplateManager;
import org.sonatype.nexus.ldap.internal.ui.LdapSchemaTemplateXO;
import org.sonatype.nexus.ldap.internal.ui.LdapServerConnectionXO;
import org.sonatype.nexus.ldap.internal.ui.LdapServerXO;
import org.sonatype.nexus.ldap.internal.ui.ReferenceXO;
import org.sonatype.nexus.ldap.persist.LdapConfigurationManager;
import org.sonatype.nexus.ldap.persist.entity.Connection;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.entity.Mapping;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.ssl.TrustStore;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@DirectAction(action={"ldap_LdapServer"})
public class LdapServerComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private LdapConfigurationManager ldapConfigurationManager;
    @Inject
    private LdapSchemaTemplateManager templateManager;
    @Inject
    private LdapConnectionTester ldapConnectionTester;
    @Inject
    private EnterpriseLdapManager ldapManager;
    @Inject
    private TrustStore trustStore;
    @Inject
    private Validator validator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LdapServerComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<LdapServerXO> read() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Reference counter = new Reference((Object)1);
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call((Object)this.ldapConfigurationManager), (Object)new GeneratedClosure((Object)this, (Object)this, counter){
            private /* synthetic */ Reference counter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.counter = reference = counter;
            }

            public Object doCall(Object input) {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callCurrent((GroovyObject)this, input), (Object)new GeneratedClosure((Object)this, this.getThisObject(), this.counter){
                    private /* synthetic */ Reference counter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.counter = reference = counter;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        Object object = this.counter.get();
                        this.counter.set(callSiteArray[0].call(object));
                        Object object2 = object;
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _closure5.class, (GroovyObject)this, (String)"order");
                        return it;
                    }

                    public Object getCounter() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.counter.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "next";
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }

            public Object getCounter() {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                return this.counter.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _read_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "with";
                stringArray[1] = "asLdapServerXO";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _read_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_read_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _read_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<ReferenceXO> readReferences() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].call((Object)this.ldapConfigurationManager), (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _readReferences_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object input) {
                CallSite[] callSiteArray = _readReferences_closure2.$getCallSiteArray();
                return callSiteArray[0].callConstructor(ReferenceXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[1].callGetProperty(input), "name", callSiteArray[2].callGetProperty(input)}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readReferences_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "id";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _readReferences_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_readReferences_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readReferences_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<LdapSchemaTemplateXO> readTemplates() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].callGetProperty((Object)this.templateManager), (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _readTemplates_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object template) {
                CallSite[] callSiteArray = _readTemplates_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, template);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readTemplates_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "asLdapSchemaTemplateXO";
                return new CallSiteArray(_readTemplates_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readTemplates_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:create"})
    @Validate(groups={Create.class, Default.class})
    public LdapServerXO create(@NotNull @Valid LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Object id = callSiteArray[6].call((Object)this.ldapConfigurationManager, callSiteArray[7].callCurrent((GroovyObject)this, callSiteArray[8].callCurrent((GroovyObject)this, (Object)ldapServerXO), null));
        return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].call((Object)this.ldapConfigurationManager, id)), LdapServerXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate(groups={Update.class, Default.class})
    public LdapServerXO update(@NotNull @Valid LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        LdapConfiguration existing = (LdapConfiguration)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call((Object)this.ldapConfigurationManager, callSiteArray[12].callGroovyObjectGetProperty((Object)ldapServerXO)), LdapConfiguration.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)((Object)existing))) {
            callSiteArray[13].call((Object)this.ldapConfigurationManager, callSiteArray[14].callCurrent((GroovyObject)this, callSiteArray[15].callCurrent((GroovyObject)this, (Object)ldapServerXO), callSiteArray[16].callGetProperty(callSiteArray[17].callGetProperty((Object)existing))));
            return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callCurrent((GroovyObject)this, callSiteArray[19].call((Object)this.ldapConfigurationManager, callSiteArray[20].callGroovyObjectGetProperty((Object)ldapServerXO))), LdapServerXO.class);
        }
        throw (Throwable)callSiteArray[21].callConstructor(IllegalArgumentException.class, callSiteArray[22].call(callSiteArray[23].call((Object)"LDAP server with id \"", callSiteArray[24].callGroovyObjectGetProperty((Object)ldapServerXO)), (Object)"\" not found"));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:delete"})
    @Validate
    public void remove(@NotEmpty String id) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[25].call((Object)this.ldapConfigurationManager, (Object)id);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    public void changeOrder(List<String> orderedServerIds) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[26].call((Object)this.ldapConfigurationManager, orderedServerIds);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:delete"})
    public void clearCache() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[27].call((Object)this.ldapConfigurationManager);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate
    public void verifyConnection(@NotNull @Valid LdapServerConnectionXO ldapServerConnectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        String authPassword = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].callGroovyObjectGetProperty((Object)ldapServerConnectionXO))) {
            LdapConfiguration existing = (LdapConfiguration)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[29].call((Object)this.ldapConfigurationManager, callSiteArray[30].callGroovyObjectGetProperty((Object)ldapServerConnectionXO)), LdapConfiguration.class));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)existing))) {
                throw (Throwable)callSiteArray[31].callConstructor(IllegalArgumentException.class, callSiteArray[32].call(callSiteArray[33].call((Object)"LDAP server with id \"", callSiteArray[34].callGroovyObjectGetProperty((Object)ldapServerConnectionXO)), (Object)"\" not found"));
            }
            Object object = callSiteArray[35].callGetProperty(callSiteArray[36].callGetProperty((Object)existing));
            authPassword = ShortTypeHandling.castToString((Object)object);
        }
        try {
            callSiteArray[37].call((Object)this.ldapConnectionTester, callSiteArray[38].callCurrent((GroovyObject)this, callSiteArray[39].callCurrent((GroovyObject)this, (Object)ldapServerConnectionXO), authPassword));
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[40].callConstructor(Exception.class, callSiteArray[41].callCurrent((GroovyObject)this, (Object)"Failed to connect to LDAP Server", (Object)e));
        }
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate
    public Collection<LdapUser> verifyUserMapping(@NotNull @Valid LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        String authPassword = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)ldapServerXO))) {
            LdapConfiguration existing = (LdapConfiguration)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call((Object)this.ldapConfigurationManager, callSiteArray[44].callGroovyObjectGetProperty((Object)ldapServerXO)), LdapConfiguration.class));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)existing))) {
                throw (Throwable)callSiteArray[45].callConstructor(IllegalArgumentException.class, callSiteArray[46].call(callSiteArray[47].call((Object)"LDAP server with id \"", callSiteArray[48].callGroovyObjectGetProperty((Object)ldapServerXO)), (Object)"\" not found"));
            }
            Object object = callSiteArray[49].callGetProperty(callSiteArray[50].callGetProperty((Object)existing));
            authPassword = ShortTypeHandling.castToString((Object)object);
        }
        Collection collection = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].call((Object)this.ldapConnectionTester, callSiteArray[52].callCurrent((GroovyObject)this, callSiteArray[53].callCurrent((GroovyObject)this, (Object)ldapServerXO), authPassword), callSiteArray[54].call(LdapConnectionUtils.class, callSiteArray[55].callCurrent((GroovyObject)this, (Object)ldapServerXO, authPassword)), (Object)20), Collection.class);
        try {
            return collection;
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[56].callConstructor(Exception.class, callSiteArray[57].callCurrent((GroovyObject)this, (Object)"Failed to connect to LDAP Server", (Object)e));
        }
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate
    public void verifyLogin(@NotNull @Valid LdapServerXO ldapServerXO, @NotEmpty String base64Username, @NotEmpty String base64Password) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        String authPassword = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].callGroovyObjectGetProperty((Object)ldapServerXO))) {
            LdapConfiguration existing = (LdapConfiguration)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call((Object)this.ldapConfigurationManager, callSiteArray[60].callGroovyObjectGetProperty((Object)ldapServerXO)), LdapConfiguration.class));
            if (!DefaultTypeTransformation.booleanUnbox((Object)((Object)existing))) {
                throw (Throwable)callSiteArray[61].callConstructor(IllegalArgumentException.class, callSiteArray[62].call(callSiteArray[63].call((Object)"LDAP server with id \"", callSiteArray[64].callGroovyObjectGetProperty((Object)ldapServerXO)), (Object)"\" not found"));
            }
            Object object = callSiteArray[65].callGetProperty(callSiteArray[66].callGetProperty((Object)existing));
            authPassword = ShortTypeHandling.castToString((Object)object);
        }
        try {
            callSiteArray[67].call((Object)this.ldapManager, callSiteArray[68].call(Strings2.class, (Object)base64Username), callSiteArray[69].call(Strings2.class, (Object)base64Password), callSiteArray[70].callCurrent((GroovyObject)this, callSiteArray[71].callCurrent((GroovyObject)this, (Object)ldapServerXO), authPassword));
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[72].callConstructor(Exception.class, callSiteArray[73].callCurrent((GroovyObject)this, (Object)"Failed to connect to LDAP Server", (Object)e));
        }
    }

    LdapServerXO asLdapServerXO(LdapConfiguration ldapServer) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Connection connectionInfo = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[74].callGetProperty((Object)ldapServer), Connection.class);
        Mapping userAndGroupConfig = (Mapping)ScriptBytecodeAdapter.castToType((Object)callSiteArray[75].callGetProperty((Object)ldapServer), Mapping.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object[] objectArray = new Object[64];
            objectArray[0] = "id";
            objectArray[1] = callSiteArray[77].callGetProperty((Object)ldapServer);
            objectArray[2] = "name";
            objectArray[3] = callSiteArray[78].callGetProperty((Object)ldapServer);
            objectArray[4] = "url";
            objectArray[5] = callSiteArray[79].callCurrent((GroovyObject)this, (Object)connectionInfo);
            objectArray[6] = "protocol";
            objectArray[7] = callSiteArray[80].call(callSiteArray[81].callGetProperty(callSiteArray[82].callGetProperty((Object)connectionInfo)));
            objectArray[8] = "useTrustStore";
            objectArray[9] = callSiteArray[83].callGetProperty((Object)connectionInfo);
            objectArray[10] = "host";
            objectArray[11] = callSiteArray[84].callGetProperty(callSiteArray[85].callGetProperty((Object)connectionInfo));
            objectArray[12] = "port";
            objectArray[13] = callSiteArray[86].callGetProperty(callSiteArray[87].callGetProperty((Object)connectionInfo));
            objectArray[14] = "searchBase";
            objectArray[15] = callSiteArray[88].callGetProperty((Object)connectionInfo);
            objectArray[16] = "authScheme";
            objectArray[17] = callSiteArray[89].callGetProperty((Object)connectionInfo);
            objectArray[18] = "authRealm";
            objectArray[19] = callSiteArray[90].callGetProperty((Object)connectionInfo);
            objectArray[20] = "authUsername";
            objectArray[21] = callSiteArray[91].callGetProperty((Object)connectionInfo);
            objectArray[22] = "authPassword";
            objectArray[23] = callSiteArray[92].call(PasswordPlaceholder.class, callSiteArray[93].callGetProperty((Object)connectionInfo));
            objectArray[24] = "connectionTimeout";
            objectArray[25] = callSiteArray[94].callGetProperty((Object)connectionInfo);
            objectArray[26] = "connectionRetryDelay";
            objectArray[27] = callSiteArray[95].callGetProperty((Object)connectionInfo);
            objectArray[28] = "maxIncidentsCount";
            objectArray[29] = callSiteArray[96].callGetProperty((Object)connectionInfo);
            objectArray[30] = "userBaseDn";
            objectArray[31] = callSiteArray[97].callGetProperty((Object)userAndGroupConfig);
            objectArray[32] = "userSubtree";
            objectArray[33] = callSiteArray[98].callGetProperty((Object)userAndGroupConfig);
            objectArray[34] = "userObjectClass";
            objectArray[35] = callSiteArray[99].callGetProperty((Object)userAndGroupConfig);
            objectArray[36] = "userLdapFilter";
            objectArray[37] = callSiteArray[100].callGetProperty((Object)userAndGroupConfig);
            objectArray[38] = "userIdAttribute";
            objectArray[39] = callSiteArray[101].callGetProperty((Object)userAndGroupConfig);
            objectArray[40] = "userRealNameAttribute";
            objectArray[41] = callSiteArray[102].callGetProperty((Object)userAndGroupConfig);
            objectArray[42] = "userEmailAddressAttribute";
            objectArray[43] = callSiteArray[103].callGetProperty((Object)userAndGroupConfig);
            objectArray[44] = "userPasswordAttribute";
            objectArray[45] = callSiteArray[104].callGetProperty((Object)userAndGroupConfig);
            objectArray[46] = "ldapGroupsAsRoles";
            objectArray[47] = callSiteArray[105].callGetProperty((Object)userAndGroupConfig);
            objectArray[48] = "groupType";
            objectArray[49] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[106].callGetProperty((Object)userAndGroupConfig)) ? (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[107].callGetProperty((Object)userAndGroupConfig)) ? "dynamic" : "static") : null;
            objectArray[50] = "userMemberOfAttribute";
            objectArray[51] = callSiteArray[108].callGetProperty((Object)userAndGroupConfig);
            objectArray[52] = "groupBaseDn";
            objectArray[53] = callSiteArray[109].callGetProperty((Object)userAndGroupConfig);
            objectArray[54] = "groupSubtree";
            objectArray[55] = callSiteArray[110].callGetProperty((Object)userAndGroupConfig);
            objectArray[56] = "groupIdAttribute";
            objectArray[57] = callSiteArray[111].callGetProperty((Object)userAndGroupConfig);
            objectArray[58] = "groupMemberAttribute";
            objectArray[59] = callSiteArray[112].callGetProperty((Object)userAndGroupConfig);
            objectArray[60] = "groupMemberFormat";
            objectArray[61] = callSiteArray[113].callGetProperty((Object)userAndGroupConfig);
            objectArray[62] = "groupObjectClass";
            objectArray[63] = callSiteArray[114].callGetProperty((Object)userAndGroupConfig);
            return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[76].callConstructor(LdapServerXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), LdapServerXO.class);
        }
        Object[] objectArray = new Object[64];
        objectArray[0] = "id";
        objectArray[1] = callSiteArray[116].callGetProperty((Object)ldapServer);
        objectArray[2] = "name";
        objectArray[3] = callSiteArray[117].callGetProperty((Object)ldapServer);
        objectArray[4] = "url";
        objectArray[5] = this.asLdapServerUrl(connectionInfo);
        objectArray[6] = "protocol";
        objectArray[7] = callSiteArray[118].call(callSiteArray[119].callGetProperty(callSiteArray[120].callGetProperty((Object)connectionInfo)));
        objectArray[8] = "useTrustStore";
        objectArray[9] = callSiteArray[121].callGetProperty((Object)connectionInfo);
        objectArray[10] = "host";
        objectArray[11] = callSiteArray[122].callGetProperty(callSiteArray[123].callGetProperty((Object)connectionInfo));
        objectArray[12] = "port";
        objectArray[13] = callSiteArray[124].callGetProperty(callSiteArray[125].callGetProperty((Object)connectionInfo));
        objectArray[14] = "searchBase";
        objectArray[15] = callSiteArray[126].callGetProperty((Object)connectionInfo);
        objectArray[16] = "authScheme";
        objectArray[17] = callSiteArray[127].callGetProperty((Object)connectionInfo);
        objectArray[18] = "authRealm";
        objectArray[19] = callSiteArray[128].callGetProperty((Object)connectionInfo);
        objectArray[20] = "authUsername";
        objectArray[21] = callSiteArray[129].callGetProperty((Object)connectionInfo);
        objectArray[22] = "authPassword";
        objectArray[23] = callSiteArray[130].call(PasswordPlaceholder.class, callSiteArray[131].callGetProperty((Object)connectionInfo));
        objectArray[24] = "connectionTimeout";
        objectArray[25] = callSiteArray[132].callGetProperty((Object)connectionInfo);
        objectArray[26] = "connectionRetryDelay";
        objectArray[27] = callSiteArray[133].callGetProperty((Object)connectionInfo);
        objectArray[28] = "maxIncidentsCount";
        objectArray[29] = callSiteArray[134].callGetProperty((Object)connectionInfo);
        objectArray[30] = "userBaseDn";
        objectArray[31] = callSiteArray[135].callGetProperty((Object)userAndGroupConfig);
        objectArray[32] = "userSubtree";
        objectArray[33] = callSiteArray[136].callGetProperty((Object)userAndGroupConfig);
        objectArray[34] = "userObjectClass";
        objectArray[35] = callSiteArray[137].callGetProperty((Object)userAndGroupConfig);
        objectArray[36] = "userLdapFilter";
        objectArray[37] = callSiteArray[138].callGetProperty((Object)userAndGroupConfig);
        objectArray[38] = "userIdAttribute";
        objectArray[39] = callSiteArray[139].callGetProperty((Object)userAndGroupConfig);
        objectArray[40] = "userRealNameAttribute";
        objectArray[41] = callSiteArray[140].callGetProperty((Object)userAndGroupConfig);
        objectArray[42] = "userEmailAddressAttribute";
        objectArray[43] = callSiteArray[141].callGetProperty((Object)userAndGroupConfig);
        objectArray[44] = "userPasswordAttribute";
        objectArray[45] = callSiteArray[142].callGetProperty((Object)userAndGroupConfig);
        objectArray[46] = "ldapGroupsAsRoles";
        objectArray[47] = callSiteArray[143].callGetProperty((Object)userAndGroupConfig);
        objectArray[48] = "groupType";
        objectArray[49] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[144].callGetProperty((Object)userAndGroupConfig)) ? (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[145].callGetProperty((Object)userAndGroupConfig)) ? "dynamic" : "static") : null;
        objectArray[50] = "userMemberOfAttribute";
        objectArray[51] = callSiteArray[146].callGetProperty((Object)userAndGroupConfig);
        objectArray[52] = "groupBaseDn";
        objectArray[53] = callSiteArray[147].callGetProperty((Object)userAndGroupConfig);
        objectArray[54] = "groupSubtree";
        objectArray[55] = callSiteArray[148].callGetProperty((Object)userAndGroupConfig);
        objectArray[56] = "groupIdAttribute";
        objectArray[57] = callSiteArray[149].callGetProperty((Object)userAndGroupConfig);
        objectArray[58] = "groupMemberAttribute";
        objectArray[59] = callSiteArray[150].callGetProperty((Object)userAndGroupConfig);
        objectArray[60] = "groupMemberFormat";
        objectArray[61] = callSiteArray[151].callGetProperty((Object)userAndGroupConfig);
        objectArray[62] = "groupObjectClass";
        objectArray[63] = callSiteArray[152].callGetProperty((Object)userAndGroupConfig);
        return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[115].callConstructor(LdapServerXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), LdapServerXO.class);
    }

    String asLdapServerUrl(Connection connectionInfo) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[153].call(callSiteArray[154].callConstructor(LdapURL.class, callSiteArray[155].call(callSiteArray[156].callGetProperty(callSiteArray[157].callGetProperty((Object)connectionInfo))), callSiteArray[158].callGetProperty(callSiteArray[159].callGetProperty((Object)connectionInfo)), callSiteArray[160].callGetProperty(callSiteArray[161].callGetProperty((Object)connectionInfo)), callSiteArray[162].callGetProperty((Object)connectionInfo))));
    }

    LdapSchemaTemplateXO asLdapSchemaTemplateXO(LdapSchemaTemplate template) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Mapping userAndGroupConfig = (Mapping)ScriptBytecodeAdapter.castToType((Object)callSiteArray[163].callGetProperty((Object)template), Mapping.class);
        Object[] objectArray = new Object[36];
        objectArray[0] = "name";
        objectArray[1] = callSiteArray[165].callGetProperty((Object)template);
        objectArray[2] = "userBaseDn";
        objectArray[3] = callSiteArray[166].callGetProperty((Object)userAndGroupConfig);
        objectArray[4] = "userSubtree";
        objectArray[5] = callSiteArray[167].callGetProperty((Object)userAndGroupConfig);
        objectArray[6] = "userObjectClass";
        objectArray[7] = callSiteArray[168].callGetProperty((Object)userAndGroupConfig);
        objectArray[8] = "userLdapFilter";
        objectArray[9] = callSiteArray[169].callGetProperty((Object)userAndGroupConfig);
        objectArray[10] = "userIdAttribute";
        objectArray[11] = callSiteArray[170].callGetProperty((Object)userAndGroupConfig);
        objectArray[12] = "userRealNameAttribute";
        objectArray[13] = callSiteArray[171].callGetProperty((Object)userAndGroupConfig);
        objectArray[14] = "userEmailAddressAttribute";
        objectArray[15] = callSiteArray[172].callGetProperty((Object)userAndGroupConfig);
        objectArray[16] = "userPasswordAttribute";
        objectArray[17] = callSiteArray[173].callGetProperty((Object)userAndGroupConfig);
        objectArray[18] = "ldapGroupsAsRoles";
        objectArray[19] = callSiteArray[174].callGetProperty((Object)userAndGroupConfig);
        objectArray[20] = "groupType";
        objectArray[21] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[175].callGetProperty((Object)userAndGroupConfig)) ? (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[176].callGetProperty((Object)userAndGroupConfig)) ? "dynamic" : "static") : null;
        objectArray[22] = "userMemberOfAttribute";
        objectArray[23] = callSiteArray[177].callGetProperty((Object)userAndGroupConfig);
        objectArray[24] = "groupBaseDn";
        objectArray[25] = callSiteArray[178].callGetProperty((Object)userAndGroupConfig);
        objectArray[26] = "groupSubtree";
        objectArray[27] = callSiteArray[179].callGetProperty((Object)userAndGroupConfig);
        objectArray[28] = "groupIdAttribute";
        objectArray[29] = callSiteArray[180].callGetProperty((Object)userAndGroupConfig);
        objectArray[30] = "groupMemberAttribute";
        objectArray[31] = callSiteArray[181].callGetProperty((Object)userAndGroupConfig);
        objectArray[32] = "groupMemberFormat";
        objectArray[33] = callSiteArray[182].callGetProperty((Object)userAndGroupConfig);
        objectArray[34] = "groupObjectClass";
        objectArray[35] = callSiteArray[183].callGetProperty((Object)userAndGroupConfig);
        return (LdapSchemaTemplateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[164].callConstructor(LdapSchemaTemplateXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), LdapSchemaTemplateXO.class);
    }

    LdapConfiguration asCLdapServerConfiguration(LdapServerXO ldapServerXO, String authPassword) {
        Object object;
        Reference ldapServerXO2 = new Reference((Object)ldapServerXO);
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Object mapping = callSiteArray[184].callConstructor(Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"userBaseDn", callSiteArray[185].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userSubtree", DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[186].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())))) ? object : Boolean.valueOf(false), "userObjectClass", callSiteArray[187].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "ldapFilter", callSiteArray[188].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userIdAttribute", callSiteArray[189].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userRealNameAttribute", callSiteArray[190].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "emailAddressAttribute", callSiteArray[191].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userPasswordAttribute", callSiteArray[192].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "ldapGroupsAsRoles", callSiteArray[193].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get()))}));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[194].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[195].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), (Object)"dynamic")) {
                Object object2 = callSiteArray[196].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get()));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)mapping, (String)"userMemberOfAttribute");
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[197].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), (Object)"static")) {
                callSiteArray[198].call(mapping, (Object)new GeneratedClosure((Object)this, (Object)this, ldapServerXO2){
                    private /* synthetic */ Reference ldapServerXO;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.ldapServerXO = reference = ldapServerXO;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        Object object = callSiteArray[0].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupBaseDn");
                        Object object2 = callSiteArray[1].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Boolean.valueOf(false);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupSubtree");
                        Object object4 = callSiteArray[2].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupIdAttribute");
                        Object object5 = callSiteArray[3].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object5, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupMemberAttribute");
                        Object object6 = callSiteArray[4].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object6, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupMemberFormat");
                        Object object7 = callSiteArray[5].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object7, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupObjectClass");
                        return object7;
                    }

                    public LdapServerXO getLdapServerXO() {
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)this.ldapServerXO.get(), LdapServerXO.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _asCLdapServerConfiguration_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "groupBaseDn";
                        stringArray[1] = "groupSubtree";
                        stringArray[2] = "groupIdAttribute";
                        stringArray[3] = "groupMemberAttribute";
                        stringArray[4] = "groupMemberFormat";
                        stringArray[5] = "groupObjectClass";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _asCLdapServerConfiguration_closure4.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_asCLdapServerConfiguration_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _asCLdapServerConfiguration_closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                });
            }
        }
        return (LdapConfiguration)((Object)ScriptBytecodeAdapter.castToType((Object)callSiteArray[199].callConstructor(LdapConfiguration.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[200].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "name", callSiteArray[201].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "connection", callSiteArray[202].callCurrent((GroovyObject)this, (Object)((LdapServerXO)ldapServerXO2.get()), (Object)authPassword), "mapping", mapping})), LdapConfiguration.class));
    }

    Connection asConnection(LdapServerConnectionXO connectionXO, String authPassword) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[203].callConstructor(Connection.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"host", callSiteArray[204].callConstructor(Connection.Host.class, callSiteArray[205].call(Connection.Protocol.class, callSiteArray[206].call(callSiteArray[207].callGroovyObjectGetProperty((Object)connectionXO))), callSiteArray[208].callGroovyObjectGetProperty((Object)connectionXO), callSiteArray[209].callGroovyObjectGetProperty((Object)connectionXO)), "useTrustStore", callSiteArray[210].call(callSiteArray[211].callGetProperty(Boolean.class), callSiteArray[212].callGroovyObjectGetProperty((Object)connectionXO)), "searchBase", callSiteArray[213].callGroovyObjectGetProperty((Object)connectionXO), "authScheme", callSiteArray[214].callGroovyObjectGetProperty((Object)connectionXO), "saslRealm", callSiteArray[215].callGroovyObjectGetProperty((Object)connectionXO), "systemUsername", callSiteArray[216].callGroovyObjectGetProperty((Object)connectionXO), "systemPassword", DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[217].call(PasswordPlaceholder.class, callSiteArray[218].callGroovyObjectGetProperty((Object)connectionXO))) ? authPassword : callSiteArray[219].callGroovyObjectGetProperty((Object)connectionXO), "connectionTimeout", callSiteArray[220].callGroovyObjectGetProperty((Object)connectionXO), "connectionRetryDelay", callSiteArray[221].callGroovyObjectGetProperty((Object)connectionXO), "maxIncidentsCount", callSiteArray[222].callGroovyObjectGetProperty((Object)connectionXO)})), Connection.class);
    }

    LdapServerConnectionXO validate(LdapServerConnectionXO ldapServerConnectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[223].callGroovyObjectGetProperty((Object)ldapServerConnectionXO), (Object)"none")) {
            callSiteArray[224].call((Object)this.validator, (Object)ldapServerConnectionXO, LdapServerConnectionXO.AuthScheme.class);
        }
        return ldapServerConnectionXO;
    }

    LdapServerXO validate(LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[225].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)ldapServerXO, LdapServerConnectionXO.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[226].callGroovyObjectGetProperty((Object)ldapServerXO))) {
            callSiteArray[227].call((Object)this.validator, (Object)ldapServerXO, ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[228].callGroovyObjectGetProperty((Object)ldapServerXO), (Object)"static") ? LdapServerXO.GroupStatic.class : LdapServerXO.GroupDynamic.class);
        }
        return ldapServerXO;
    }

    private LdapContextFactory buildLdapContextFactory(LdapServerConnectionXO connectionXO, String authPassword) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return (LdapContextFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[229].call(LdapConnectionUtils.class, callSiteArray[230].callConstructor(LdapConfiguration.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"connection", callSiteArray[231].callCurrent((GroovyObject)this, (Object)connectionXO, (Object)authPassword)})), (Object)this.trustStore), LdapContextFactory.class);
    }

    String buildReason(String userMessage, Throwable t) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{userMessage, callSiteArray[232].callGetProperty((Object)t)}, new String[]{"", ": ", ""}));
        while (ScriptBytecodeAdapter.compareNotEqual((Object)t, (Object)callSiteArray[233].callGetProperty((Object)t)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[234].callGetProperty((Object)t))) {
            Object object = callSiteArray[235].callGetProperty((Object)t);
            t = (Throwable)ScriptBytecodeAdapter.castToType((Object)object, Throwable.class);
            message = ShortTypeHandling.castToString((Object)callSiteArray[236].call((Object)message, (Object)new GStringImpl(new Object[]{callSiteArray[237].callGetProperty(callSiteArray[238].call((Object)t)), callSiteArray[239].callGetProperty((Object)t)}, new String[]{" [Caused by ", ": ", "]"})));
        }
        return message;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LdapServerComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public LdapConfigurationManager getLdapConfigurationManager() {
        return this.ldapConfigurationManager;
    }

    public void setLdapConfigurationManager(LdapConfigurationManager ldapConfigurationManager) {
        this.ldapConfigurationManager = ldapConfigurationManager;
    }

    public LdapSchemaTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(LdapSchemaTemplateManager ldapSchemaTemplateManager) {
        this.templateManager = ldapSchemaTemplateManager;
    }

    public LdapConnectionTester getLdapConnectionTester() {
        return this.ldapConnectionTester;
    }

    public void setLdapConnectionTester(LdapConnectionTester ldapConnectionTester) {
        this.ldapConnectionTester = ldapConnectionTester;
    }

    public EnterpriseLdapManager getLdapManager() {
        return this.ldapManager;
    }

    public void setLdapManager(EnterpriseLdapManager enterpriseLdapManager) {
        this.ldapManager = enterpriseLdapManager;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "collect";
        stringArray[1] = "listLdapServerConfigurations";
        stringArray[2] = "collect";
        stringArray[3] = "listLdapServerConfigurations";
        stringArray[4] = "collect";
        stringArray[5] = "schemaTemplates";
        stringArray[6] = "addLdapServerConfiguration";
        stringArray[7] = "asCLdapServerConfiguration";
        stringArray[8] = "validate";
        stringArray[9] = "asLdapServerXO";
        stringArray[10] = "getLdapServerConfiguration";
        stringArray[11] = "getLdapServerConfiguration";
        stringArray[12] = "id";
        stringArray[13] = "updateLdapServerConfiguration";
        stringArray[14] = "asCLdapServerConfiguration";
        stringArray[15] = "validate";
        stringArray[16] = "systemPassword";
        stringArray[17] = "connection";
        stringArray[18] = "asLdapServerXO";
        stringArray[19] = "getLdapServerConfiguration";
        stringArray[20] = "id";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "id";
        stringArray[25] = "deleteLdapServerConfiguration";
        stringArray[26] = "setServerOrder";
        stringArray[27] = "clearCache";
        stringArray[28] = "id";
        stringArray[29] = "getLdapServerConfiguration";
        stringArray[30] = "id";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "id";
        stringArray[35] = "systemPassword";
        stringArray[36] = "connection";
        stringArray[37] = "testConnection";
        stringArray[38] = "buildLdapContextFactory";
        stringArray[39] = "validate";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "buildReason";
        stringArray[42] = "id";
        stringArray[43] = "getLdapServerConfiguration";
        stringArray[44] = "id";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "plus";
        stringArray[47] = "plus";
        stringArray[48] = "id";
        stringArray[49] = "systemPassword";
        stringArray[50] = "connection";
        stringArray[51] = "testUserAndGroupMapping";
        stringArray[52] = "buildLdapContextFactory";
        stringArray[53] = "validate";
        stringArray[54] = "getLdapAuthConfiguration";
        stringArray[55] = "asCLdapServerConfiguration";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "buildReason";
        stringArray[58] = "id";
        stringArray[59] = "getLdapServerConfiguration";
        stringArray[60] = "id";
        stringArray[61] = "<$constructor$>";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "id";
        stringArray[65] = "systemPassword";
        stringArray[66] = "connection";
        stringArray[67] = "authenticateUserTest";
        stringArray[68] = "decodeBase64";
        stringArray[69] = "decodeBase64";
        stringArray[70] = "asCLdapServerConfiguration";
        stringArray[71] = "validate";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "buildReason";
        stringArray[74] = "connection";
        stringArray[75] = "mapping";
        stringArray[76] = "<$constructor$>";
        stringArray[77] = "id";
        stringArray[78] = "name";
        stringArray[79] = "asLdapServerUrl";
        stringArray[80] = "name";
        stringArray[81] = "protocol";
        stringArray[82] = "host";
        stringArray[83] = "useTrustStore";
        stringArray[84] = "hostName";
        stringArray[85] = "host";
        stringArray[86] = "port";
        stringArray[87] = "host";
        stringArray[88] = "searchBase";
        stringArray[89] = "authScheme";
        stringArray[90] = "saslRealm";
        stringArray[91] = "systemUsername";
        stringArray[92] = "get";
        stringArray[93] = "systemPassword";
        stringArray[94] = "connectionTimeout";
        stringArray[95] = "connectionRetryDelay";
        stringArray[96] = "maxIncidentsCount";
        stringArray[97] = "userBaseDn";
        stringArray[98] = "userSubtree";
        stringArray[99] = "userObjectClass";
        stringArray[100] = "ldapFilter";
        stringArray[101] = "userIdAttribute";
        stringArray[102] = "userRealNameAttribute";
        stringArray[103] = "emailAddressAttribute";
        stringArray[104] = "userPasswordAttribute";
        stringArray[105] = "ldapGroupsAsRoles";
        stringArray[106] = "ldapGroupsAsRoles";
        stringArray[107] = "userMemberOfAttribute";
        stringArray[108] = "userMemberOfAttribute";
        stringArray[109] = "groupBaseDn";
        stringArray[110] = "groupSubtree";
        stringArray[111] = "groupIdAttribute";
        stringArray[112] = "groupMemberAttribute";
        stringArray[113] = "groupMemberFormat";
        stringArray[114] = "groupObjectClass";
        stringArray[115] = "<$constructor$>";
        stringArray[116] = "id";
        stringArray[117] = "name";
        stringArray[118] = "name";
        stringArray[119] = "protocol";
        stringArray[120] = "host";
        stringArray[121] = "useTrustStore";
        stringArray[122] = "hostName";
        stringArray[123] = "host";
        stringArray[124] = "port";
        stringArray[125] = "host";
        stringArray[126] = "searchBase";
        stringArray[127] = "authScheme";
        stringArray[128] = "saslRealm";
        stringArray[129] = "systemUsername";
        stringArray[130] = "get";
        stringArray[131] = "systemPassword";
        stringArray[132] = "connectionTimeout";
        stringArray[133] = "connectionRetryDelay";
        stringArray[134] = "maxIncidentsCount";
        stringArray[135] = "userBaseDn";
        stringArray[136] = "userSubtree";
        stringArray[137] = "userObjectClass";
        stringArray[138] = "ldapFilter";
        stringArray[139] = "userIdAttribute";
        stringArray[140] = "userRealNameAttribute";
        stringArray[141] = "emailAddressAttribute";
        stringArray[142] = "userPasswordAttribute";
        stringArray[143] = "ldapGroupsAsRoles";
        stringArray[144] = "ldapGroupsAsRoles";
        stringArray[145] = "userMemberOfAttribute";
        stringArray[146] = "userMemberOfAttribute";
        stringArray[147] = "groupBaseDn";
        stringArray[148] = "groupSubtree";
        stringArray[149] = "groupIdAttribute";
        stringArray[150] = "groupMemberAttribute";
        stringArray[151] = "groupMemberFormat";
        stringArray[152] = "groupObjectClass";
        stringArray[153] = "toString";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "name";
        stringArray[156] = "protocol";
        stringArray[157] = "host";
        stringArray[158] = "hostName";
        stringArray[159] = "host";
        stringArray[160] = "port";
        stringArray[161] = "host";
        stringArray[162] = "searchBase";
        stringArray[163] = "userAndGroupAuthConfig";
        stringArray[164] = "<$constructor$>";
        stringArray[165] = "name";
        stringArray[166] = "userBaseDn";
        stringArray[167] = "userSubtree";
        stringArray[168] = "userObjectClass";
        stringArray[169] = "ldapFilter";
        stringArray[170] = "userIdAttribute";
        stringArray[171] = "userRealNameAttribute";
        stringArray[172] = "emailAddressAttribute";
        stringArray[173] = "userPasswordAttribute";
        stringArray[174] = "ldapGroupsAsRoles";
        stringArray[175] = "ldapGroupsAsRoles";
        stringArray[176] = "userMemberOfAttribute";
        stringArray[177] = "userMemberOfAttribute";
        stringArray[178] = "groupBaseDn";
        stringArray[179] = "groupSubtree";
        stringArray[180] = "groupIdAttribute";
        stringArray[181] = "groupMemberAttribute";
        stringArray[182] = "groupMemberFormat";
        stringArray[183] = "groupObjectClass";
        stringArray[184] = "<$constructor$>";
        stringArray[185] = "userBaseDn";
        stringArray[186] = "userSubtree";
        stringArray[187] = "userObjectClass";
        stringArray[188] = "userLdapFilter";
        stringArray[189] = "userIdAttribute";
        stringArray[190] = "userRealNameAttribute";
        stringArray[191] = "userEmailAddressAttribute";
        stringArray[192] = "userPasswordAttribute";
        stringArray[193] = "ldapGroupsAsRoles";
        stringArray[194] = "ldapGroupsAsRoles";
        stringArray[195] = "groupType";
        stringArray[196] = "userMemberOfAttribute";
        stringArray[197] = "groupType";
        stringArray[198] = "with";
        stringArray[199] = "<$constructor$>";
        stringArray[200] = "id";
        stringArray[201] = "name";
        stringArray[202] = "asConnection";
        stringArray[203] = "<$constructor$>";
        stringArray[204] = "<$constructor$>";
        stringArray[205] = "valueOf";
        stringArray[206] = "name";
        stringArray[207] = "protocol";
        stringArray[208] = "host";
        stringArray[209] = "port";
        stringArray[210] = "equals";
        stringArray[211] = "TRUE";
        stringArray[212] = "useTrustStore";
        stringArray[213] = "searchBase";
        stringArray[214] = "authScheme";
        stringArray[215] = "authRealm";
        stringArray[216] = "authUsername";
        stringArray[217] = "is";
        stringArray[218] = "authPassword";
        stringArray[219] = "authPassword";
        stringArray[220] = "connectionTimeout";
        stringArray[221] = "connectionRetryDelay";
        stringArray[222] = "maxIncidentsCount";
        stringArray[223] = "authScheme";
        stringArray[224] = "validate";
        stringArray[225] = "validate";
        stringArray[226] = "ldapGroupsAsRoles";
        stringArray[227] = "validate";
        stringArray[228] = "groupType";
        stringArray[229] = "getLdapContextFactory";
        stringArray[230] = "<$constructor$>";
        stringArray[231] = "asConnection";
        stringArray[232] = "message";
        stringArray[233] = "cause";
        stringArray[234] = "cause";
        stringArray[235] = "cause";
        stringArray[236] = "plus";
        stringArray[237] = "name";
        stringArray[238] = "getClass";
        stringArray[239] = "message";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[240];
        LdapServerComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LdapServerComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LdapServerComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

