/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

public final class Connection {
    private String searchBase;
    @Nullable
    private String systemUsername;
    @Nullable
    private String systemPassword;
    private String authScheme;
    private Host host;
    private boolean useTrustStore;
    @Nullable
    private String saslRealm;
    private int connectionTimeout;
    private int connectionRetryDelay;
    private int maxIncidentsCount;

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)searchBase) ? 1 : 0) != 0, (Object)"searchBase empty");
        this.searchBase = searchBase;
    }

    public String getSystemUsername() {
        return this.systemUsername;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public String getSystemPassword() {
        return this.systemPassword;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public String getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        Preconditions.checkArgument((host != null ? 1 : 0) != 0, (Object)"host null");
        this.host = host;
    }

    public boolean getUseTrustStore() {
        return this.useTrustStore;
    }

    public void setUseTrustStore(@Nullable Boolean useTrustStore) {
        this.useTrustStore = useTrustStore == null ? false : useTrustStore;
    }

    public String getSaslRealm() {
        return this.saslRealm;
    }

    public void setSaslRealm(String realm) {
        this.saslRealm = realm;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionRetryDelay() {
        return this.connectionRetryDelay;
    }

    public void setConnectionRetryDelay(int connectionRetryDelay) {
        this.connectionRetryDelay = connectionRetryDelay;
    }

    public int getMaxIncidentsCount() {
        return this.maxIncidentsCount;
    }

    public void setMaxIncidentsCount(int maxIncidentsCount) {
        this.maxIncidentsCount = maxIncidentsCount;
    }

    public static final class Host {
        private Protocol protocol;
        private String hostName;
        private int port;

        @VisibleForTesting
        public Host() {
        }

        public Host(Protocol protocol, String hostName, int port) {
            this.setProtocol(protocol);
            this.setHostName(hostName);
            this.setPort(port);
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public void setProtocol(Protocol protocol) {
            Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol null");
            this.protocol = protocol;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hostName) ? 1 : 0) != 0, (Object)"hostName empty");
            this.hostName = hostName;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            Preconditions.checkArgument((port > 0 && port < 65536 ? 1 : 0) != 0, (String)"Invalid LDAP port: %s", (int)port);
            this.port = port;
        }

        public String toString() {
            return "Host{protocol=" + (Object)((Object)this.protocol) + ", hostName='" + this.hostName + '\'' + ", port=" + this.port + '}';
        }
    }

    public static enum Protocol {
        ldap,
        ldaps;

    }
}

