/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.ldap.persist.LdapCacheInvalidatedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationCreatedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationDeletedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationManager;
import org.sonatype.nexus.ldap.persist.LdapConfigurationUpdatedEvent;
import org.sonatype.nexus.ldap.persist.LdapServerNotFoundException;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.internal.LdapConfigurationSource;
import org.sonatype.nexus.ldap.persist.internal.Validator;
import org.sonatype.nexus.security.realm.RealmManager;

@Named
@Singleton
public class DefaultLdapConfigurationManager
extends ComponentSupport
implements LdapConfigurationManager {
    private final LdapConfigurationSource configurationSource;
    private final Validator validator;
    private final EventManager eventManager;
    private final RealmManager realmManager;
    private final LinkedHashMap<String, LdapConfiguration> cache;
    private boolean cachePrimed;

    @Inject
    public DefaultLdapConfigurationManager(LdapConfigurationSource configurationSource, Validator validator, EventManager eventManager, RealmManager realmManager) {
        this.configurationSource = (LdapConfigurationSource)Preconditions.checkNotNull((Object)configurationSource);
        this.validator = (Validator)Preconditions.checkNotNull((Object)validator);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.cache = Maps.newLinkedHashMap();
        this.cachePrimed = false;
    }

    @Override
    public synchronized void clearCache() {
        this.cache.clear();
        this.cachePrimed = false;
        this.eventManager.post((Object)new LdapCacheInvalidatedEvent());
    }

    @Override
    public synchronized void setServerOrder(List<String> orderdServerIds) {
        Preconditions.checkNotNull(orderdServerIds);
        LinkedHashMap<String, LdapConfiguration> configuration = this.getConfiguration();
        HashSet newOrder = Sets.newHashSet(orderdServerIds);
        Preconditions.checkArgument((newOrder.size() == orderdServerIds.size() ? 1 : 0) != 0, (String)"Duplicate keys provided: %s", orderdServerIds);
        Set<String> configIds = configuration.keySet();
        Preconditions.checkArgument((boolean)newOrder.equals(configIds), (String)"ID ordering mismatch (the new and existing should differ in order only):  new=%s, existing=%s)", orderdServerIds, configIds);
        for (LdapConfiguration config : configuration.values()) {
            config.setOrder(orderdServerIds.indexOf(config.getId()));
            this.configurationSource.update(config);
        }
        this.clearCache();
    }

    @Override
    public synchronized List<LdapConfiguration> listLdapServerConfigurations() {
        return ImmutableList.copyOf(this.getConfiguration().values());
    }

    @Override
    public synchronized LdapConfiguration getLdapServerConfiguration(String id) throws LdapServerNotFoundException {
        Preconditions.checkNotNull((Object)id);
        LdapConfiguration configuration = this.getConfiguration().get(id);
        if (configuration != null) {
            return configuration;
        }
        throw new LdapServerNotFoundException("Ldap Server: '" + id + "' was not found.");
    }

    @Override
    public synchronized String addLdapServerConfiguration(LdapConfiguration ldapServerConfiguration) {
        Preconditions.checkNotNull((Object)((Object)ldapServerConfiguration));
        this.validator.validate(ldapServerConfiguration);
        ldapServerConfiguration.setOrder(Integer.MAX_VALUE);
        LinkedHashMap<String, LdapConfiguration> config = this.getConfiguration();
        ArrayList existingIds = Lists.newArrayList(config.keySet());
        boolean firstEntry = config.isEmpty();
        this.configurationSource.create(ldapServerConfiguration);
        this.clearCache();
        existingIds.add(ldapServerConfiguration.getId());
        this.setServerOrder(existingIds);
        this.eventManager.post((Object)new LdapConfigurationCreatedEvent(ldapServerConfiguration));
        if (firstEntry) {
            this.mayActivateLdapRealm();
        }
        return ldapServerConfiguration.getId();
    }

    @Override
    public synchronized void updateLdapServerConfiguration(LdapConfiguration ldapServerConfiguration) throws LdapServerNotFoundException {
        Preconditions.checkNotNull((Object)((Object)ldapServerConfiguration));
        this.validator.validate(ldapServerConfiguration);
        Preconditions.checkArgument((ldapServerConfiguration.getId() != null ? 1 : 0) != 0, (Object)"'id' is null, cannot update");
        LinkedHashMap<String, LdapConfiguration> config = this.getConfiguration();
        if (!config.containsKey(ldapServerConfiguration.getId())) {
            throw new LdapServerNotFoundException("Ldap Server: '" + ldapServerConfiguration.getId() + "' was not found.");
        }
        this.configurationSource.update(ldapServerConfiguration);
        this.clearCache();
        this.eventManager.post((Object)new LdapConfigurationUpdatedEvent(ldapServerConfiguration));
    }

    @Override
    public synchronized void deleteLdapServerConfiguration(String id) throws LdapServerNotFoundException {
        Preconditions.checkNotNull((Object)id);
        LinkedHashMap<String, LdapConfiguration> config = this.getConfiguration();
        boolean lastEntry = config.size() == 1;
        LdapConfiguration ldapServerConfiguration = config.get(id);
        if (ldapServerConfiguration != null) {
            this.configurationSource.delete(id);
            this.clearCache();
            this.eventManager.post((Object)new LdapConfigurationDeletedEvent(ldapServerConfiguration));
            if (lastEntry) {
                this.mayDeactivateLdapRealm();
            }
            return;
        }
        throw new LdapServerNotFoundException("Ldap Server: '" + id + "' was not found.");
    }

    private void mayActivateLdapRealm() {
        this.realmManager.enableRealm("LdapRealm");
    }

    private void mayDeactivateLdapRealm() {
        this.realmManager.disableRealm("LdapRealm");
    }

    private LinkedHashMap<String, LdapConfiguration> getConfiguration() {
        if (!this.cachePrimed) {
            try {
                this.cache.clear();
                ArrayList ldapConfigurations = Lists.newArrayList(this.configurationSource.loadAll());
                Collections.sort(ldapConfigurations, new Comparator<LdapConfiguration>(){

                    @Override
                    public int compare(LdapConfiguration o1, LdapConfiguration o2) {
                        return o1.getOrder() - o2.getOrder();
                    }
                });
                for (LdapConfiguration ldapConfiguration : ldapConfigurations) {
                    this.cache.put(ldapConfiguration.getId(), ldapConfiguration);
                }
                this.cachePrimed = true;
            }
            catch (Exception e) {
                this.log.warn("Cannot retrieve LDAP configuration", (Throwable)e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.cache;
    }
}

