/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ldap.persist.entity.Connection;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.entity.Mapping;

@Singleton
@Named
public final class Validator {
    public void validate(LdapConfiguration ldapConfiguration) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)ldapConfiguration.getName()) ? 1 : 0) != 0, (Object)"name");
        Preconditions.checkArgument((ldapConfiguration.getConnection() != null ? 1 : 0) != 0, (Object)"connection");
        Preconditions.checkArgument((ldapConfiguration.getMapping() != null ? 1 : 0) != 0, (Object)"mapping");
        this.validate(ldapConfiguration.getConnection());
        this.validate(ldapConfiguration.getMapping());
    }

    public void validate(Connection connection) {
        Preconditions.checkNotNull((Object)connection);
        Preconditions.checkArgument((connection.getHost() != null ? 1 : 0) != 0, (Object)"connection.host");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connection.getAuthScheme()) ? 1 : 0) != 0, (Object)"connection.authScheme");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connection.getSearchBase()) ? 1 : 0) != 0, (Object)"connection.searchBase");
        if (!Strings.isNullOrEmpty((String)connection.getAuthScheme()) && !"none".equals(connection.getAuthScheme())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)connection.getSystemUsername()) && !Strings.isNullOrEmpty((String)connection.getSystemPassword()) ? 1 : 0) != 0, (Object)"connection.systemUsername");
        }
    }

    public void validate(Mapping mapping) {
        Preconditions.checkNotNull((Object)mapping);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getUserObjectClass()) ? 1 : 0) != 0, (Object)"mapping.userObjectClass");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getUserIdAttribute()) ? 1 : 0) != 0, (Object)"mapping.userIdAttribute");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getUserRealNameAttribute()) ? 1 : 0) != 0, (Object)"mapping.userRealNameAttribute");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getEmailAddressAttribute()) ? 1 : 0) != 0, (Object)"mapping.emailAddressAttribute");
        if (mapping.isLdapGroupsAsRoles() && Strings.isNullOrEmpty((String)mapping.getUserMemberOfAttribute())) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getGroupIdAttribute()) ? 1 : 0) != 0, (Object)"mapping.groupIdAttribute");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getGroupMemberAttribute()) ? 1 : 0) != 0, (Object)"mapping.groupMemberAttribute");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getGroupMemberFormat()) ? 1 : 0) != 0, (Object)"mapping.groupMemberFormat");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)mapping.getGroupObjectClass()) ? 1 : 0) != 0, (Object)"mapping.groupObjectClass");
        }
    }
}

