/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ldap.persist.entity.Connection;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.entity.Mapping;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.security.PasswordHelper;

@Named
@Singleton
public class LdapConfigurationEntityAdapter
extends IterableEntityAdapter<LdapConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("ldap").build();
    private static final String DB_CONNECTION_HOST_CLASS = new OClassNameBuilder().prefix("ldap").type("host").build();
    private static final String DB_CONNECTION_CLASS = new OClassNameBuilder().prefix("ldap").type("connection").build();
    private static final String DB_MAPPING_CLASS = new OClassNameBuilder().prefix("ldap").type("mapping").build();
    private static final String P_ID = "id";
    private static final String P_NAME = "name";
    private static final String P_ORDER = "order";
    private static final String P_CONNECTION = "connection";
    private static final String P_MAPPING = "mapping";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private final PasswordHelper passwordHelper;

    @Inject
    public LdapConfigurationEntityAdapter(PasswordHelper passwordHelper) {
        super(DB_CLASS);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    protected void defineType(ODatabaseDocumentTx db, OClass type) {
        OSchemaProxy schema = db.getMetadata().getSchema();
        OClass connectionHostType = schema.createClass(DB_CONNECTION_HOST_CLASS);
        connectionHostType.createProperty("protocol", OType.STRING).setNotNull(true);
        connectionHostType.createProperty("hostName", OType.STRING).setNotNull(true);
        connectionHostType.createProperty("port", OType.INTEGER).setNotNull(true);
        OClass connectionType = schema.createClass(DB_CONNECTION_CLASS);
        connectionType.createProperty("searchBase", OType.STRING).setNotNull(true);
        connectionType.createProperty("systemUsername", OType.STRING);
        connectionType.createProperty("systemPassword", OType.STRING);
        connectionType.createProperty("authScheme", OType.STRING).setNotNull(true);
        connectionType.createProperty("host", OType.EMBEDDED, connectionHostType).setNotNull(true);
        connectionType.createProperty("saslRealm", OType.STRING);
        connectionType.createProperty("connectionTimeout", OType.INTEGER).setNotNull(true);
        connectionType.createProperty("connectionRetryDelay", OType.INTEGER).setNotNull(true);
        connectionType.createProperty("maxIncidentsCount", OType.INTEGER).setNotNull(true);
        OClass mappingType = schema.createClass(DB_MAPPING_CLASS);
        mappingType.createProperty("emailAddressAttribute", OType.STRING).setNotNull(true);
        mappingType.createProperty("ldapGroupsAsRoles", OType.BOOLEAN).setNotNull(true);
        mappingType.createProperty("groupBaseDn", OType.STRING);
        mappingType.createProperty("groupIdAttribute", OType.STRING);
        mappingType.createProperty("groupMemberAttribute", OType.STRING);
        mappingType.createProperty("groupMemberFormat", OType.STRING);
        mappingType.createProperty("groupObjectClass", OType.STRING);
        mappingType.createProperty("userPasswordAttribute", OType.STRING);
        mappingType.createProperty("userIdAttribute", OType.STRING).setNotNull(true);
        mappingType.createProperty("userObjectClass", OType.STRING).setNotNull(true);
        mappingType.createProperty("ldapFilter", OType.STRING);
        mappingType.createProperty("userBaseDn", OType.STRING);
        mappingType.createProperty("userRealNameAttribute", OType.STRING).setNotNull(true);
        mappingType.createProperty("userSubtree", OType.BOOLEAN);
        mappingType.createProperty("groupSubtree", OType.BOOLEAN);
        mappingType.createProperty("userMemberOfAttribute", OType.STRING);
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setNotNull(true);
        type.createProperty(P_ORDER, OType.INTEGER).setNotNull(true);
        type.createProperty(P_CONNECTION, OType.EMBEDDED, connectionType).setNotNull(true);
        type.createProperty(P_MAPPING, OType.EMBEDDED, mappingType).setNotNull(true);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
    }

    public ODocument selectById(ODatabaseDocumentTx db, String id) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        OSQLSynchQuery query = new OSQLSynchQuery("SELECT FROM " + DB_CLASS + " WHERE " + P_ID + " = ?");
        List results = (List)db.command((OCommandRequest)query).execute(new Object[]{id});
        if (!results.isEmpty()) {
            return (ODocument)results.get(0);
        }
        return null;
    }

    protected void defineType(OClass type) {
        throw new UnsupportedOperationException();
    }

    protected LdapConfiguration newEntity() {
        return new LdapConfiguration();
    }

    protected void readFields(ODocument document, LdapConfiguration entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setOrder((Integer)document.field(P_ORDER, OType.INTEGER));
        entity.setConnection(this.toConnection((ODocument)document.field(P_CONNECTION, OType.EMBEDDED)));
        entity.setMapping(this.toMapping((ODocument)document.field(P_MAPPING, OType.EMBEDDED)));
    }

    protected void writeFields(ODocument document, LdapConfiguration entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_ORDER, (Object)entity.getOrder());
        document.field(P_CONNECTION, (Object)this.fromConnection(entity.getConnection()));
        document.field(P_MAPPING, (Object)this.fromMapping(entity.getMapping()));
    }

    private Connection toConnection(ODocument document) {
        Connection connection = new Connection();
        connection.setSearchBase((String)document.field("searchBase", OType.STRING));
        connection.setSystemUsername((String)document.field("systemUsername", OType.STRING));
        connection.setSystemPassword(this.passwordHelper.tryDecrypt((String)document.field("systemPassword", OType.STRING)));
        connection.setAuthScheme((String)document.field("authScheme", OType.STRING));
        ODocument hostDocument = (ODocument)document.field("host", OType.EMBEDDED);
        Connection.Host host = new Connection.Host(Connection.Protocol.valueOf((String)hostDocument.field("protocol", OType.STRING)), (String)hostDocument.field("hostName", OType.STRING), (Integer)hostDocument.field("port", OType.INTEGER));
        connection.setHost(host);
        connection.setUseTrustStore((Boolean)document.field("useTrustStore", OType.BOOLEAN));
        connection.setSaslRealm((String)document.field("saslRealm", OType.STRING));
        connection.setConnectionTimeout((Integer)document.field("connectionTimeout", OType.INTEGER));
        connection.setConnectionRetryDelay((Integer)document.field("connectionRetryDelay", OType.INTEGER));
        connection.setMaxIncidentsCount((Integer)document.field("maxIncidentsCount", OType.INTEGER));
        return connection;
    }

    private ODocument fromConnection(Connection connection) {
        ODocument document = new ODocument(DB_CONNECTION_CLASS);
        document.field("searchBase", (Object)connection.getSearchBase());
        document.field("systemUsername", (Object)connection.getSystemUsername());
        document.field("systemPassword", (Object)this.passwordHelper.encrypt(connection.getSystemPassword()));
        document.field("authScheme", (Object)connection.getAuthScheme());
        ODocument hostDocument = new ODocument(DB_CONNECTION_HOST_CLASS);
        hostDocument.field("protocol", (Object)connection.getHost().getProtocol().name());
        hostDocument.field("hostName", (Object)connection.getHost().getHostName());
        hostDocument.field("port", (Object)connection.getHost().getPort());
        document.field("host", (Object)hostDocument);
        document.field("useTrustStore", (Object)connection.getUseTrustStore());
        document.field("saslRealm", (Object)connection.getSaslRealm());
        document.field("connectionTimeout", (Object)connection.getConnectionTimeout());
        document.field("connectionRetryDelay", (Object)connection.getConnectionRetryDelay());
        document.field("maxIncidentsCount", (Object)connection.getMaxIncidentsCount());
        return document;
    }

    private Mapping toMapping(ODocument document) {
        Mapping mapping = new Mapping();
        mapping.setEmailAddressAttribute((String)document.field("emailAddressAttribute", OType.STRING));
        mapping.setLdapGroupsAsRoles((Boolean)document.field("ldapGroupsAsRoles", OType.BOOLEAN));
        mapping.setGroupBaseDn((String)document.field("groupBaseDn", OType.STRING));
        mapping.setGroupIdAttribute((String)document.field("groupIdAttribute", OType.STRING));
        mapping.setGroupMemberAttribute((String)document.field("groupMemberAttribute", OType.STRING));
        mapping.setGroupMemberFormat((String)document.field("groupMemberFormat", OType.STRING));
        mapping.setGroupObjectClass((String)document.field("groupObjectClass", OType.STRING));
        mapping.setUserPasswordAttribute((String)document.field("userPasswordAttribute", OType.STRING));
        mapping.setUserIdAttribute((String)document.field("userIdAttribute", OType.STRING));
        mapping.setUserObjectClass((String)document.field("userObjectClass", OType.STRING));
        mapping.setLdapFilter((String)document.field("ldapFilter", OType.STRING));
        mapping.setUserBaseDn((String)document.field("userBaseDn", OType.STRING));
        mapping.setUserRealNameAttribute((String)document.field("userRealNameAttribute", OType.STRING));
        mapping.setUserSubtree((Boolean)document.field("userSubtree", OType.BOOLEAN));
        mapping.setGroupSubtree((Boolean)document.field("groupSubtree", OType.BOOLEAN));
        mapping.setUserMemberOfAttribute((String)document.field("userMemberOfAttribute", OType.STRING));
        return mapping;
    }

    private ODocument fromMapping(Mapping mapping) {
        ODocument document = new ODocument(DB_MAPPING_CLASS);
        document.field("emailAddressAttribute", (Object)mapping.getEmailAddressAttribute());
        document.field("ldapGroupsAsRoles", (Object)mapping.isLdapGroupsAsRoles());
        document.field("groupBaseDn", (Object)mapping.getGroupBaseDn());
        document.field("groupIdAttribute", (Object)mapping.getGroupIdAttribute());
        document.field("groupMemberAttribute", (Object)mapping.getGroupMemberAttribute());
        document.field("groupMemberFormat", (Object)mapping.getGroupMemberFormat());
        document.field("groupObjectClass", (Object)mapping.getGroupObjectClass());
        document.field("userPasswordAttribute", (Object)mapping.getUserPasswordAttribute());
        document.field("userIdAttribute", (Object)mapping.getUserIdAttribute());
        document.field("userObjectClass", (Object)mapping.getUserObjectClass());
        document.field("ldapFilter", (Object)mapping.getLdapFilter());
        document.field("userBaseDn", (Object)mapping.getUserBaseDn());
        document.field("userRealNameAttribute", (Object)mapping.getUserRealNameAttribute());
        document.field("userSubtree", (Object)mapping.isUserSubtree());
        document.field("groupSubtree", (Object)mapping.isGroupSubtree());
        document.field("userMemberOfAttribute", (Object)mapping.getUserMemberOfAttribute());
        return document;
    }
}

