/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.thread.TcclBlock;
import org.sonatype.nexus.rest.client.RestClientConfiguration;
import org.sonatype.nexus.rest.client.RestClientFactory;
import org.sonatype.nexus.rest.client.internal.BridgeClassLoader;

@Named(value="default")
@Singleton
public class RestClientFactoryImpl
extends ComponentSupport
implements RestClientFactory {
    private final LoadingCache<ClassLoader, ClassLoader> bridgeClassLoaderCache = CacheBuilder.newBuilder().build(CacheLoader.from(loader -> new BridgeClassLoader((ClassLoader)loader, ProxyBuilder.class.getClassLoader())));
    private final Provider<HttpClient> httpClient;

    @Inject
    public RestClientFactoryImpl(Provider<HttpClient> httpClient) {
        this.httpClient = (Provider)Preconditions.checkNotNull(httpClient);
    }

    @Override
    public Client create(RestClientConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        Throwable throwable = null;
        Object var3_4 = null;
        try (TcclBlock tccl = TcclBlock.begin(ResteasyClientBuilder.class);){
            BasicHttpContext httpContext = new BasicHttpContext();
            if (configuration.getUseTrustStore()) {
                httpContext.setAttribute("nexus.httpclient.ssl.trustStore", (Object)true);
            }
            HttpClient client = configuration.getHttpClient() != null ? (HttpClient)Preconditions.checkNotNull((Object)configuration.getHttpClient().get()) : (HttpClient)this.httpClient.get();
            ApacheHttpClient4Engine httpEngine = new ApacheHttpClient4Engine(client, (HttpContext)httpContext);
            ResteasyClientBuilder builder = new ResteasyClientBuilder().httpEngine((ClientHttpEngine)httpEngine);
            if (configuration.getCustomizer() != null) {
                configuration.getCustomizer().apply((Configurable<?>)builder);
            }
            return builder.build();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public <T> T proxy(Class<T> api, Client client, URI baseUri) {
        WebTarget target = client.target(baseUri);
        return (T)ProxyBuilder.builder(api, (WebTarget)target).classloader((ClassLoader)this.bridgeClassLoaderCache.getUnchecked((Object)api.getClassLoader())).build();
    }
}

