/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.sonatype.nexus.supportzip.ContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;

public class FileContentSourceSupport
extends ContentSourceSupport {
    protected final File file;

    public FileContentSourceSupport(SupportBundle.ContentSource.Type type, String path, File file, SupportBundle.ContentSource.Priority priority) {
        super(type, path, priority);
        this.file = (File)Preconditions.checkNotNull((Object)file);
    }

    public FileContentSourceSupport(SupportBundle.ContentSource.Type type, String path, File file) {
        this(type, path, file, SupportBundle.ContentSource.Priority.DEFAULT);
    }

    @Override
    public void prepare() throws Exception {
        Preconditions.checkState((boolean)this.file.exists());
    }

    @Override
    public long getSize() {
        Preconditions.checkState((boolean)this.file.exists());
        return this.file.length();
    }

    @Override
    public InputStream getContent() throws Exception {
        Preconditions.checkState((boolean)this.file.exists());
        this.log.debug("Reading: {}", (Object)this.file);
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public void cleanup() throws Exception {
    }
}

