/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import org.sonatype.nexus.supportzip.ContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;

public abstract class GeneratedContentSourceSupport
extends ContentSourceSupport {
    protected File file;

    public GeneratedContentSourceSupport(SupportBundle.ContentSource.Type type, String path) {
        super(type, path);
    }

    public GeneratedContentSourceSupport(SupportBundle.ContentSource.Type type, String path, SupportBundle.ContentSource.Priority priority) {
        super(type, path, priority);
    }

    @Override
    public void prepare() throws Exception {
        Preconditions.checkState((this.file == null ? 1 : 0) != 0);
        this.file = File.createTempFile(String.valueOf(this.getPath().replaceAll("/", "-")) + "-", ".tmp").getCanonicalFile();
        this.log.trace("Preparing: {}", (Object)this.file);
        this.generate(this.file);
    }

    protected abstract void generate(File var1) throws Exception;

    @Override
    public long getSize() {
        Preconditions.checkState((boolean)this.file.exists());
        return this.file.length();
    }

    @Override
    public InputStream getContent() throws Exception {
        Preconditions.checkState((boolean)this.file.exists());
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public void cleanup() throws Exception {
        if (this.file != null) {
            this.log.trace("Cleaning: {}", (Object)this.file);
            Files.delete(this.file.toPath());
            this.file = null;
        }
    }
}

