/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.sonatype.nexus.supportzip.FileContentSourceSupport;
import org.sonatype.nexus.supportzip.SupportBundle;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class SanitizedXmlSourceSupport
extends FileContentSourceSupport {
    private final String stylesheet;
    private byte[] content;

    public SanitizedXmlSourceSupport(SupportBundle.ContentSource.Type type, String path, File file, SupportBundle.ContentSource.Priority priority, String stylesheet) {
        super(type, path, file, priority);
        this.stylesheet = (String)Preconditions.checkNotNull((Object)stylesheet);
    }

    @Override
    public void prepare() throws Exception {
        super.prepare();
        Preconditions.checkState((this.content == null ? 1 : 0) != 0);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(this.file));){
            Throwable throwable2 = null;
            Object var6_9 = null;
            try (BufferedOutputStream output = new BufferedOutputStream(stream);){
                StreamSource styleSource = new StreamSource(new StringReader(this.stylesheet));
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(styleSource);
                SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                parserFactory.setNamespaceAware(true);
                SAXParser parser = parserFactory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                transformer.transform(new SAXSource(reader, new InputSource(input)), new StreamResult(output));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        this.content = stream.toByteArray();
    }

    @Override
    public long getSize() {
        Preconditions.checkState((this.content != null ? 1 : 0) != 0);
        return this.content.length;
    }

    @Override
    public InputStream getContent() throws Exception {
        Preconditions.checkState((this.content != null ? 1 : 0) != 0);
        this.log.debug("Reading: {} from memory", (Object)this.file);
        return new BufferedInputStream(new ByteArrayInputStream(this.content));
    }
}

