/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.supportzip;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.List;

public class SupportBundle {
    private final List<ContentSource> sources = Lists.newArrayList();

    public List<ContentSource> getSources() {
        return this.sources;
    }

    public void add(ContentSource contentSource) {
        Preconditions.checkNotNull((Object)contentSource);
        this.sources.add(contentSource);
    }

    public void leftShift(ContentSource contentSource) {
        this.add(contentSource);
    }

    public static interface ContentSource
    extends Comparable<ContentSource> {
        public Type getType();

        public String getPath();

        public Priority getPriority();

        public long getSize();

        public InputStream getContent() throws Exception;

        public void prepare() throws Exception;

        public void cleanup() throws Exception;

        public static enum Priority {
            OPTIONAL(999),
            LOW(100),
            DEFAULT(50),
            HIGH(10),
            REQUIRED(0);

            final int order;

            private Priority(int order) {
                this.order = order;
            }
        }

        public static enum Type {
            SYSINFO,
            THREAD,
            METRICS,
            CONFIG,
            SECURITY,
            LOG,
            TASKLOG,
            JMX;

        }
    }
}

