/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.servlet.ManagedServletPipeline;
import com.google.inject.servlet.PipelineLogger;
import com.google.inject.servlet.ServletDefinition;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.wire.EntryListAdapter;

@Singleton
final class DynamicServletPipeline
extends ManagedServletPipeline {
    static final Injector DUMMY_INJECTOR = Guice.createInjector((Module[])new Module[0]);
    private final List<ServletDefinition> servletDefinitions;
    private volatile ServletDefinition[] servletDefinitionCache = new ServletDefinition[0];

    @Inject
    DynamicServletPipeline(BeanLocator locator) {
        super(DUMMY_INJECTOR);
        this.servletDefinitions = new EntryListAdapter(locator.locate(Key.get(ServletDefinition.class)));
    }

    public synchronized void refreshCache() {
        Object[] snapshot = this.servletDefinitions.toArray();
        this.servletDefinitionCache = (ServletDefinition[])Arrays.copyOf(snapshot, snapshot.length, ServletDefinition[].class);
        PipelineLogger.dump(this.servletDefinitionCache);
    }

    public boolean service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions();
        int n = servletDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDefinition servletDefinition = servletDefinitionArray[n2];
            if (servletDefinition.service(request, response)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void destroy() {
        Set destroyedSoFar = Sets.newIdentityHashSet();
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions();
        int n = servletDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServletDefinition servletDefinition = servletDefinitionArray[n2];
            servletDefinition.destroy(destroyedSoFar);
            ++n2;
        }
    }

    RequestDispatcher getRequestDispatcher(final String path) {
        ServletDefinition[] servletDefinitionArray = this.servletDefinitions();
        int n = servletDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            final ServletDefinition servletDefinition = servletDefinitionArray[n2];
            if (servletDefinition.shouldServe(path)) {
                return new RequestDispatcher(){

                    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                        Preconditions.checkState((!servletResponse.isCommitted() ? 1 : 0) != 0, (Object)"Response has been committed--you can only call forward before committing the response (hint: don't flush buffers)");
                        servletResponse.resetBuffer();
                        ServletRequest requestToProcess = servletRequest instanceof HttpServletRequest ? DynamicServletPipeline.wrapRequest((HttpServletRequest)((HttpServletRequest)servletRequest), (String)path) : servletRequest;
                        this.doServiceImpl(requestToProcess, servletResponse);
                    }

                    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                        this.doServiceImpl(servletRequest, servletResponse);
                    }

                    private void doServiceImpl(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                        servletRequest.setAttribute("javax.servlet.forward.servlet_path", (Object)Boolean.TRUE);
                        try {
                            servletDefinition.doService(servletRequest, servletResponse);
                        }
                        finally {
                            servletRequest.removeAttribute("javax.servlet.forward.servlet_path");
                        }
                    }
                };
            }
            ++n2;
        }
        return null;
    }

    protected boolean hasServletsMapped() {
        return this.servletDefinitionCache.length > 0;
    }

    private ServletDefinition[] servletDefinitions() {
        return this.servletDefinitionCache;
    }
}

