/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapabilityDescriptor;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.io.DirectoryHelper;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.authz.AuthorizationManager;
import org.sonatype.nexus.security.authz.NoSuchAuthorizationManagerException;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.role.Role;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.UserNotFoundException;

public class OutreachHelper
extends ComponentSupport {
    private static final String TMP_DIR_NAME = "outreach";
    private final File tmpDir;
    private final SecuritySystem securitySystem;
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public OutreachHelper(ApplicationDirectories directories, SecuritySystem securitySystem, CapabilityRegistry capabilityRegistry) throws Exception {
        Preconditions.checkNotNull((Object)directories);
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.tmpDir = new File(directories.getTemporaryDirectory(), TMP_DIR_NAME).getAbsoluteFile();
        DirectoryHelper.mkdir((Path)this.tmpDir.toPath());
    }

    public File getTemporaryDirectory() {
        return this.tmpDir;
    }

    public boolean isEnabled() {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities().withType(OutreachManagementCapabilityDescriptor.TYPE);
        Collection references = this.capabilityRegistry.get((Predicate)filter);
        if (references.isEmpty()) {
            return false;
        }
        return ((CapabilityReference)references.iterator().next()).context().isActive();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAdminRole(Subject subject) {
        if (subject == null) return false;
        if (subject.getPrincipal() == null) {
            return false;
        }
        if (subject.hasRole("nx-admin")) {
            return true;
        }
        try {
            RoleIdentifier roleIdentifier;
            Set roleIdentifiers = this.securitySystem.getUser(String.valueOf(subject.getPrincipal())).getRoles();
            AuthorizationManager authorizationManager = this.securitySystem.getAuthorizationManager("default");
            HashSet<String> processedRoleIds = new HashSet<String>();
            Iterator iterator = roleIdentifiers.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.hasAdminRole(authorizationManager, (roleIdentifier = (RoleIdentifier)iterator.next()).getRoleId(), processedRoleIds));
            return true;
        }
        catch (NoSuchAuthorizationManagerException | UserNotFoundException e) {
            this.lookupError((Exception)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasAdminRole(AuthorizationManager authorizationManager, String roleId, Set<String> processedRoleIds) {
        if (processedRoleIds.contains(roleId)) {
            return false;
        }
        processedRoleIds.add(roleId);
        try {
            String childRoleId;
            Role role = authorizationManager.getRole(roleId);
            if ("nx-admin".equals(role.getRoleId())) {
                return true;
            }
            Iterator iterator = role.getRoles().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.hasAdminRole(authorizationManager, childRoleId = (String)iterator.next(), processedRoleIds));
            return true;
        }
        catch (NoSuchRoleException e) {
            this.lookupError((Exception)((Object)e));
        }
        return false;
    }

    private void lookupError(Exception e) {
        this.log.debug("Could not check if current subject has admin role.", (Throwable)e);
    }
}

