/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal;

import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundle;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.mime.RegexpMimeRulesSource;

public class PageBundleMimeRulesSource
extends RegexpMimeRulesSource {
    private static final Logger log = LoggerFactory.getLogger(PageBundleMimeRulesSource.class);
    private long tstamp;

    public PageBundleMimeRulesSource(PageBundle bundle) {
        this.setup(bundle.getEntry("mime.properties"));
    }

    private void setup(PageBundleEntry entry) {
        if (entry.exists()) {
            this.tstamp = entry.getTime();
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream in = entry.getContent().openStream();){
                    this.setup(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                log.warn("Could not setup custom mime rules", (Throwable)e);
            }
        }
    }

    private void setup(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        this.setup(properties);
    }

    private void setup(Properties properties) {
        Set<Object> objects = properties.keySet();
        for (Object key : objects) {
            super.addRule(".*\\." + key + "$", properties.getProperty(key.toString(), "application/octet-stream"));
        }
    }

    public boolean isValidFor(PageBundle bundle) {
        PageBundleEntry entry = bundle.getEntry("mime.properties");
        return entry.exists() && entry.getTime() == this.tstamp;
    }
}

