/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.validation.constraint.UrlString;

public class OutreachManagementCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String BASE_URL = "baseUrl";
    public static final String CACHING_DISABLED = "alwaysRemote";
    public static final String OVERRIDE_URL = "overrideUrl";
    @NotEmpty
    @UrlString
    private String baseUrl;
    private Boolean alwaysRemote;
    @UrlString
    private String overrideUrl;

    public OutreachManagementCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.baseUrl = properties.getOrDefault(BASE_URL, "https://links.sonatype.com/products/nexus/outreach");
        this.alwaysRemote = this.parseBoolean(properties.get(CACHING_DISABLED), false);
        this.overrideUrl = properties.get(OVERRIDE_URL);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isCachingDisabled() {
        return this.alwaysRemote;
    }

    public String getOverrideUrl() {
        return this.overrideUrl;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(BASE_URL, this.baseUrl);
        props.put(CACHING_DISABLED, String.valueOf(this.alwaysRemote));
        if (this.overrideUrl != null) {
            props.put(OVERRIDE_URL, this.overrideUrl);
        }
        return props;
    }

    public String toString() {
        return "OutreachManagementCapabilityConfiguration{baseUrl='" + this.baseUrl + '\'' + ", alwaysRemote='" + this.alwaysRemote + '\'' + ", overrideUrl='" + this.overrideUrl + '\'' + '}';
    }
}

