/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.plugins.outreach.internal.OutreachConfiguration;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapabilityConfiguration;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.UrlFormField;

@Named(value="OutreachManagementCapability")
@Singleton
public class OutreachManagementCapabilityDescriptor
extends CapabilityDescriptorSupport<OutreachManagementCapabilityConfiguration> {
    static final String TYPE_ID = "OutreachManagementCapability";
    static final String NAME = "Outreach: Management";
    static final String BASE_URL_LABEL = "Default Outreach Content URL";
    static final String BASE_URL_HELP_TEXT = "Default external URL for downloading new Outreach content.";
    static final String CACHING_LABEL = "Disable Caching";
    static final String CACHING_HELP_TEXT = "Always check the remote server for updates";
    static final String OVERRIDE_URL_LABEL = "Override Outreach Content URL";
    static final String OVERRIDE_URL_HELP_TEXT = "Override external URL for downloading new Outreach content.<br/>Leave empty to disable the override.";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"OutreachManagementCapability");
    private final List<FormField> formFields;
    private final OutreachConfiguration configuration;

    @Inject
    public OutreachManagementCapabilityDescriptor(OutreachConfiguration configuration) {
        this.configuration = (OutreachConfiguration)Preconditions.checkNotNull((Object)configuration);
        this.formFields = Lists.newArrayList((Object[])new FormField[]{this.buildBaseUrlFormField(), this.buildCachingCheckboxFormField(), this.buildOverrideUrlFormField()});
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return NAME;
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected OutreachManagementCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new OutreachManagementCapabilityConfiguration(properties);
    }

    public boolean isHidden() {
        return true;
    }

    protected String renderAbout() throws Exception {
        return this.render("OutreachManagementCapability-about.vm");
    }

    private UrlFormField buildBaseUrlFormField() {
        UrlFormField baseUrlFormField = new UrlFormField("baseUrl", BASE_URL_LABEL, BASE_URL_HELP_TEXT, true);
        baseUrlFormField.setReadOnly(true);
        baseUrlFormField.setInitialValue((Object)this.configuration.getUrl());
        return baseUrlFormField;
    }

    private CheckboxFormField buildCachingCheckboxFormField() {
        return new CheckboxFormField("alwaysRemote", CACHING_LABEL, CACHING_HELP_TEXT, false);
    }

    private UrlFormField buildOverrideUrlFormField() {
        return new UrlFormField("overrideUrl", OVERRIDE_URL_LABEL, OVERRIDE_URL_HELP_TEXT, false);
    }
}

