/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleMetadata;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class OutreachCleanup
extends StateGuardLifecycleSupport {
    private final ApplicationDirectories applicationDirectories;

    @Inject
    public OutreachCleanup(ApplicationDirectories applicationDirectories) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
    }

    protected void doStop() throws Exception {
        File dir = new File(this.applicationDirectories.getTemporaryDirectory(), "outreach");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".metadata");
            }
        });
        if (files != null && files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File md = fileArray[n2];
                try {
                    DateTime expires = this.createNewPageBundleMetadata(md).getExpires();
                    if (expires != null && expires.isBeforeNow()) {
                        new File(md.getAbsolutePath().replace(".metadata", "")).delete();
                    }
                }
                catch (IOException e) {
                    new File(md.getAbsolutePath().replace(".metadata", "")).delete();
                    md.delete();
                    this.log.warn("While checking outreach bundle expiry could not parse metadata {}", (Object)md, (Object)e);
                }
                ++n2;
            }
        }
    }

    @VisibleForTesting
    protected PageBundleMetadata createNewPageBundleMetadata(File md) throws IOException {
        return new PageBundleMetadata(md);
    }
}

