/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.Resource;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.HealthCheckResourceService;
import com.sonatype.nexus.plugins.healthcheck.service.LicenseService;
import com.sonatype.nexus.plugins.healthcheck.service.SecurityService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpResponseException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
@Path(value="/healthcheck/clm")
public class ClmHealthCheckResource
extends ComponentSupport
implements org.sonatype.nexus.rest.Resource {
    static final String URI = "/healthcheck/clm";
    private static final String CLM_NOT_CONFIGURED = "IQ Server has not been configured";
    private static final String INVALID_RESOURCE = "The requested path is not available.";
    private static final String LICENSE_REQUIRED = "IQ Server license is required";
    private static final List<Pattern> VALID_RESOURCES = new ArrayList<Pattern>(3);
    private final ClmConnector clmConnector;
    private final SecurityService security;
    private final LicenseService license;
    private final HealthCheckResourceService healthCheckResourceService;

    static {
        VALID_RESOURCES.add(Pattern.compile("^rest/application/services/names$"));
        VALID_RESOURCES.add(Pattern.compile("^rest/integration/applications$"));
        VALID_RESOURCES.add(Pattern.compile("^rest/rm/.+$"));
    }

    @Inject
    public ClmHealthCheckResource(SecurityService security, LicenseService license, ClmConnector clmConnector, HealthCheckResourceService healthCheckResourceService) {
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
        this.license = (LicenseService)Preconditions.checkNotNull((Object)license);
        this.clmConnector = (ClmConnector)Preconditions.checkNotNull((Object)clmConnector);
        this.healthCheckResourceService = (HealthCheckResourceService)Preconditions.checkNotNull((Object)healthCheckResourceService);
    }

    @VisibleForTesting
    static boolean isValidClmResource(String path) {
        if (path.contains("../")) {
            return false;
        }
        if (path.startsWith("assets/") || path.startsWith("policy-assets/")) {
            return true;
        }
        for (Pattern p : VALID_RESOURCES) {
            if (!p.matcher(path).matches()) continue;
            return true;
        }
        return false;
    }

    @GET
    @Path(value="/{path:.*}")
    @RequiresPermissions(value={"nexus:healthcheckalerts:read"})
    public Response doGet(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="path") String contentPath) {
        response.addHeader("X-Frame-Options", "SAMEORIGIN");
        try {
            if (!this.license.isCLM()) {
                return this.getErrorContent(LICENSE_REQUIRED, contentPath, null);
            }
            if (this.security.isAnonymousUser(request)) {
                return this.getErrorContent("Must be logged in to view this content", contentPath, Response.Status.FORBIDDEN);
            }
            if (!this.clmConnector.isActive() || !this.clmConnector.isConfigured()) {
                return this.getErrorContent(CLM_NOT_CONFIGURED, contentPath, null);
            }
            if (!ClmHealthCheckResource.isValidClmResource(contentPath)) {
                this.log.error("Request for invalid CLM resource {}", (Object)contentPath);
                return this.getErrorContent(INVALID_RESOURCE, contentPath, Response.Status.BAD_REQUEST);
            }
            return this.doGetClm(contentPath, request.getParameterMap());
        }
        catch (HttpResponseException e) {
            this.log.error("An error occurred retrieving " + contentPath, (Throwable)e);
            int status = e.getStatusCode();
            if (status == 401 || status == 403) {
                status = 500;
            }
            throw new WebApplicationException(e.toString(), Response.Status.fromStatusCode((int)status));
        }
        catch (IOException e) {
            this.log.error("An error occurred retrieving " + contentPath, (Throwable)e);
            throw new WebApplicationException(e.toString(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response doGetClm(String path, Map<String, String[]> params) throws IOException {
        try {
            Resource resource = new RestClientFactory().forConfiguration(this.clmConnector.getRestConfiguration()).getResource(path, params);
            return Response.ok((Object)resource.getData(), (String)resource.getContentType()).build();
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException(e.toString(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response getErrorContent(String message, String contentPath, Response.Status status) throws IOException {
        if (contentPath.endsWith(".html")) {
            return this.healthCheckResourceService.processError(message);
        }
        throw new WebApplicationException(message, status != null ? status : Response.Status.INTERNAL_SERVER_ERROR);
    }
}

