/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal;

import com.sonatype.nexus.plugins.healthcheck.pro.internal.TemplateService;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="freemarker")
@Singleton
public class FreeMarkerServiceImpl
implements TemplateService {
    private static final Object DUMMY_TEMPLATE_SOURCE = new Object();

    @Override
    public InputStream processTemplate(String templateName, InputStream templateValue, long modificationTime, Map<String, Object> model) throws IOException, TemplateException {
        Template template = this.getFreemarkerConfiguration(templateValue, modificationTime).getTemplate(templateName);
        StringWriter writer = new StringWriter();
        template.process(model, (Writer)writer);
        return new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
    }

    private Configuration getFreemarkerConfiguration(final InputStream templateValue, final long modificationTime) {
        Configuration cfg = new Configuration();
        cfg.setTemplateLoader(new TemplateLoader(){

            public Object findTemplateSource(String name) {
                return DUMMY_TEMPLATE_SOURCE;
            }

            public long getLastModified(Object templateSource) {
                return modificationTime;
            }

            public Reader getReader(Object templateSource, String encoding) throws IOException {
                return new InputStreamReader(templateValue, encoding);
            }

            public void closeTemplateSource(Object templateSource) throws IOException {
                templateValue.close();
            }
        });
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setLocale(Locale.US);
        cfg.setLocalizedLookup(false);
        cfg.setNumberFormat("0.######");
        return cfg;
    }
}

