/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.TemplateService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

@Named
@Singleton
public class HealthCheckResourceService {
    private static final String RESOURCE_LOCATION = "/artifact-details-template/";
    private final WebServerManager webServerManager;
    private final TemplateService templateService;
    private static final Set<String> RESOURCES;

    static {
        HashSet<String> resources = new HashSet<String>();
        resources.add("index.html");
        resources.add("jquery-ui-1.8.17.custom.css");
        resources.add("jquery-3.3.1.min.js");
        resources.add("jquery.dataTables.min.js");
        resources.add("details.js");
        resources.add("jquery-ui-1.12.1.min.js");
        resources.add("sort_asc_disabled.png");
        resources.add("sort_asc.png");
        resources.add("sort_both.png");
        resources.add("sort_desc_disabled.png");
        resources.add("sort_desc.png");
        resources.add("error.html");
        resources.add("unknown-component.html");
        resources.add("security-icon_16x16.png");
        resources.add("license-icon_16x16.png");
        RESOURCES = Collections.unmodifiableSet(resources);
    }

    @Inject
    public HealthCheckResourceService(WebServerManager webServerManager, @Named(value="freemarker") TemplateService templateService) {
        this.webServerManager = (WebServerManager)Preconditions.checkNotNull((Object)webServerManager);
        this.templateService = (TemplateService)Preconditions.checkNotNull((Object)templateService);
    }

    public WebServerService.ContentItem getResource(String repositoryName, String path) throws IOException {
        WebServerService service = this.getWebServerService(repositoryName);
        WebServerService.ContentItem item = service.getContentItem(path);
        if (item == null) {
            this.extractResource(service, path);
            item = service.getContentItem(path);
        }
        return item;
    }

    public Response processError(String errorText) throws IOException {
        return this.processWithLocalTemplate("error.html", errorText);
    }

    public Response processContentNotFound(String errorText) throws IOException {
        return this.processWithLocalTemplate("unknown-component.html", errorText);
    }

    private Response processWithLocalTemplate(String templateName, String errorText) throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("errorText", errorText);
        try {
            InputStream templateStream = this.templateService.processTemplate("health-check/" + templateName, this.getClass().getResourceAsStream(RESOURCE_LOCATION + templateName), -1L, model);
            return Response.ok((Object)templateStream, (String)"text/html").build();
        }
        catch (Exception e) {
            throw new IOException("Failed to render template " + templateName + " for error :" + errorText, e);
        }
    }

    public Response process(WebServerService.ContentItem item, Map<String, Object> model) throws IOException {
        try {
            return Response.ok((Object)this.templateService.processTemplate(item.getBlob(), model), (String)item.getMediaType()).build();
        }
        catch (Exception e) {
            throw new IOException("Failed to render template for " + item.getFilename() + ": " + e.getMessage(), e);
        }
    }

    private synchronized WebServerService getWebServerService(String repositoryName) throws IOException {
        WebServerService service = this.webServerManager.getWebServer(repositoryName);
        if (service != null) {
            return service;
        }
        service = this.webServerManager.addWebServer(repositoryName);
        for (String resource : RESOURCES) {
            this.extractResource(service, resource);
        }
        return service;
    }

    private void extractResource(WebServerService service, String src) throws IOException {
        String dest = src.substring(src.lastIndexOf(47) + 1);
        this.extractFile(service, RESOURCE_LOCATION + src, dest);
    }

    private void extractFile(WebServerService service, String src, String dest) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(src);
        try {
            service.extract(dest, is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

