/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.internal.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.nexus.plugins.healthcheck.pro.internal.ui.HealthCheckAssetDetailXO;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.BucketStore;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class AssetIdentificationService {
    private final RepositoryManager repositoryManager;
    private final MavenPathParser mavenPathParser;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapterManager variableResolverAdapterManager;
    private final BucketStore bucketStore;
    private final Map<String, Function<Asset, ComponentIdentifier>> getterByFormat = new HashMap<String, Function<Asset, ComponentIdentifier>>();

    @Inject
    public AssetIdentificationService(RepositoryManager repositoryManager, BucketStore bucketStore, MavenPathParser mavenPathParser, ContentPermissionChecker contentPermissionChecker, VariableResolverAdapterManager variableResolverAdapterManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.bucketStore = (BucketStore)Preconditions.checkNotNull((Object)bucketStore);
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
        this.contentPermissionChecker = (ContentPermissionChecker)Preconditions.checkNotNull((Object)contentPermissionChecker);
        this.variableResolverAdapterManager = (VariableResolverAdapterManager)Preconditions.checkNotNull((Object)variableResolverAdapterManager);
        this.initializeGetterByFormatMap();
    }

    private void initializeGetterByFormatMap() {
        this.getterByFormat.put("maven", this::getMavenComponentIdentifier);
        this.getterByFormat.put("nuget", this::getNugetComponentIdentifier);
        this.getterByFormat.put("npm", this::getNpmComponentIdentifier);
        this.getterByFormat.put("pypi", this::getPypiComponentIdentifier);
    }

    public HealthCheckAssetDetailXO identify(String repositoryName, String assetName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        Preconditions.checkArgument((repository != null ? 1 : 0) != 0, (String)"Repository %s not found", (Object)repositoryName);
        Asset asset = (Asset)Transactional.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset result = tx.findAssetWithProperty("name", (Object)assetName);
            if (result != null) {
                String asssetBucketRepositoryName = this.bucketStore.getById(result.bucketId()).getRepositoryName();
                if (AssetIdentificationService.allMembers(repository).stream().anyMatch(repo -> repo.getName().equals(asssetBucketRepositoryName))) {
                    return result;
                }
            }
            return null;
        });
        Preconditions.checkArgument((asset != null ? 1 : 0) != 0, (String)"Asset %s not found in repository %s", (Object)assetName, (Object)repositoryName);
        this.ensurePermission(repository, asset);
        HealthCheckAssetDetailXO xo = new HealthCheckAssetDetailXO();
        xo.setHash(this.getHash(asset));
        xo.setComponentIdentifier(this.getComponentIdentifier(asset));
        return xo;
    }

    private static List<Repository> allMembers(Repository repository) {
        Optional optionalGroupFacet = repository.optionalFacet(GroupFacet.class);
        if (optionalGroupFacet.isPresent()) {
            return ((GroupFacet)optionalGroupFacet.get()).allMembers();
        }
        return Collections.singletonList(repository);
    }

    private void ensurePermission(Repository repository, Asset asset) {
        String format = repository.getFormat().getValue();
        if (!this.contentPermissionChecker.isPermitted(repository.getName(), format, "read", this.variableResolverAdapterManager.get(format).fromAsset(asset))) {
            throw new AuthorizationException();
        }
    }

    private String getHash(Asset asset) {
        HashCode hash = asset.getChecksum(HashAlgorithm.SHA1);
        Preconditions.checkState((hash != null ? 1 : 0) != 0, (String)"Asset %s has no SHA1", (Object)asset.name());
        return hash.toString();
    }

    @VisibleForTesting
    ComponentIdentifier getComponentIdentifier(Asset asset) {
        String format = this.getComponentFormat(asset.format());
        Function<Asset, ComponentIdentifier> getter = this.getterByFormat.get(format);
        if (getter == null) {
            throw new IllegalArgumentException("Unsupported format " + format);
        }
        return getter.apply(asset);
    }

    public boolean isSupportedFormat(String format) {
        return this.getterByFormat.containsKey(format);
    }

    private ComponentIdentifier getMavenComponentIdentifier(Asset asset) {
        String path = asset.name();
        MavenPath.Coordinates gav = this.mavenPathParser.parsePath(path).getCoordinates();
        Preconditions.checkArgument((gav != null ? 1 : 0) != 0, (String)"Malformed Maven component with path %s.", (Object)path);
        return ComponentIdentifier.createMavenCoordinates((String)gav.getGroupId(), (String)gav.getArtifactId(), (String)gav.getVersion(), (String)Optional.ofNullable(gav.getClassifier()).orElse(""), (String)gav.getExtension());
    }

    private ComponentIdentifier getNugetComponentIdentifier(Asset asset) {
        String path = asset.name();
        String[] pathParts = path.split("/");
        Preconditions.checkArgument((pathParts.length == 2 ? 1 : 0) != 0, (String)"Malformed NuGet component with path %.", (Object)path);
        return ComponentIdentifier.createNugetCoordinates((String)pathParts[0], (String)pathParts[1]);
    }

    private ComponentIdentifier getNpmComponentIdentifier(Asset asset) {
        String path = asset.name();
        String[] pathParts = path.split("/");
        Preconditions.checkArgument(((pathParts.length == 4 || pathParts.length == 3) && path.endsWith(".tgz") ? 1 : 0) != 0, (String)"Malformed npm component with path %s. If this is packageRoot, try selecting the tarball instead.", (Object)path);
        String packageId = pathParts[0];
        int versionIdx = 2;
        int packageIdx = 0;
        if (pathParts.length == 4) {
            packageId = String.valueOf(packageId) + "/" + pathParts[1];
            ++versionIdx;
            ++packageIdx;
        }
        String version = pathParts[versionIdx].substring(pathParts[packageIdx].length() + 1, pathParts[versionIdx].indexOf(".tgz"));
        return ComponentIdentifier.createNpmCoordinates((String)packageId, (String)version);
    }

    private ComponentIdentifier getPypiComponentIdentifier(Asset asset) {
        String name = (String)asset.formatAttributes().get("name", String.class);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Missing name attribute for PyPI asset %s.", (Object)asset.name());
        String version = (String)asset.formatAttributes().get("version", String.class);
        Preconditions.checkArgument((version != null ? 1 : 0) != 0, (String)"Missing version attribute for PyPI asset %s.", (Object)asset.name());
        String filename = asset.name();
        filename = filename.substring(filename.lastIndexOf(47) + 1);
        int extensionStart = filename.lastIndexOf(46);
        if (extensionStart >= 4 && ".tar".equals(filename.substring(extensionStart - 4, extensionStart))) {
            extensionStart -= 4;
        }
        String extension = filename.substring(extensionStart + 1);
        String classifier = null;
        int versionStart = filename.indexOf(version);
        if (versionStart >= 0) {
            int versionEnd = versionStart + version.length();
            classifier = versionEnd >= extensionStart ? "" : filename.substring(versionEnd + 1, extensionStart);
        }
        return ComponentIdentifier.createPypiCoordinates((String)name, (String)version, classifier, (String)extension);
    }

    private String getComponentFormat(String repositoryFormat) {
        if (repositoryFormat.startsWith("maven")) {
            return "maven";
        }
        return repositoryFormat;
    }
}

