/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.healthcheck.pro.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.healthcheck.rest.AbstractHealthCheckWebContentResource;
import com.sonatype.nexus.plugins.healthcheck.service.SecurityService;
import com.sonatype.nexus.plugins.healthcheck.service.WebServerManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/healthcheck/healthCheckDetail/{repositoryName}/{path:.*}")
public class HealthCheckDetailResource
extends AbstractHealthCheckWebContentResource
implements Resource {
    public static final String URI = "/healthcheck/healthCheckDetail/{repositoryName}/{path:.*}";
    private final SecurityService security;

    @Inject
    public HealthCheckDetailResource(WebServerManager webServerManager, SecurityService security) {
        super(webServerManager);
        this.security = (SecurityService)Preconditions.checkNotNull((Object)security);
    }

    protected boolean preGet(HttpServletRequest request) {
        this.security.blockAnonymousUser(request);
        return true;
    }

    @GET
    @RequiresPermissions(value={"nexus:healthcheckdetail:read"})
    public Response loadContent(@PathParam(value="repositoryName") String repositoryName, @PathParam(value="path") String path, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        return super.doGet(URI, repositoryName, path, request, response);
    }

    protected String getBaseDirectory() {
        return "details";
    }
}

