/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.search.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.search.elasticsearch.CriteriaAppender;
import org.sonatype.nexus.cleanup.service.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.QueryOptions;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class ElasticSearchCleanupComponentBrowse
extends ComponentSupport
implements CleanupComponentBrowse {
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String GROUP = "group";
    private final SearchService searchService;
    private final Map<String, CriteriaAppender> criteriaAppenders;

    @Inject
    public ElasticSearchCleanupComponentBrowse(Map<String, CriteriaAppender> criteriaAppenders, SearchService searchService) {
        this.criteriaAppenders = (Map)Preconditions.checkNotNull(criteriaAppenders);
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    @Override
    public Iterable<EntityId> browse(CleanupPolicy policy, Repository repository) {
        if (policy.getCriteria().isEmpty()) {
            return Collections.emptyList();
        }
        BoolQueryBuilder query = this.convertPolicyToQuery(policy);
        this.log.debug("Searching for components to cleanup using policy {}", (Object)policy);
        return Iterables.transform((Iterable)this.searchService.browseUnrestrictedInRepos((QueryBuilder)query, (Collection)ImmutableList.of((Object)repository.getName())), searchHit -> new DetachedEntityId(searchHit.getId()));
    }

    @Override
    public PagedResponse<Component> browseByPage(CleanupPolicy policy, Repository repository, QueryOptions options) {
        Preconditions.checkNotNull((Object)options.getStart());
        Preconditions.checkNotNull((Object)options.getLimit());
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        QueryBuilder query = this.convertPolicyToQuery(policy, options);
        this.log.debug("Searching for components to cleanup using policy {}", (Object)policy);
        SearchResponse searchResponse = this.searchService.searchUnrestrictedInRepos(query, this.getSort(options.getSortProperty(), options.getSortDirection()), options.getStart().intValue(), options.getLimit().intValue(), (Collection)ImmutableList.of((Object)repository.getName()));
        List components = StreamSupport.stream(searchResponse.getHits().spliterator(), false).map(searchHit -> tx.findComponent((EntityId)new DetachedEntityId(searchHit.getId()))).filter(Objects::nonNull).collect(Collectors.toList());
        return new PagedResponse(searchResponse.getHits().getTotalHits(), components);
    }

    private QueryBuilder convertPolicyToQuery(CleanupPolicy policy, QueryOptions options) {
        BoolQueryBuilder queryBuilder = this.convertPolicyToQuery(policy);
        if (Strings.isNullOrEmpty((String)options.getFilter())) {
            return queryBuilder;
        }
        QueryStringQueryBuilder stringQueryBuilder = QueryBuilders.queryStringQuery((String)this.addWildcard(options.getFilter())).field(NAME).field(GROUP).field(VERSION);
        return queryBuilder.must((QueryBuilder)stringQueryBuilder);
    }

    private String addWildcard(String filter) {
        return String.valueOf(filter) + "*";
    }

    private BoolQueryBuilder convertPolicyToQuery(CleanupPolicy policy) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery());
        for (Map.Entry<String, String> criteria : policy.getCriteria().entrySet()) {
            this.addCriteria(query, criteria.getKey(), criteria.getValue());
        }
        return query;
    }

    private void addCriteria(BoolQueryBuilder query, String key, String value) {
        if (!this.criteriaAppenders.containsKey(key)) {
            throw new UnsupportedOperationException("Criteria of type " + key + " is not supported");
        }
        this.criteriaAppenders.get(key).append(query, value);
    }

    private List<SortBuilder> getSort(String sortProperty, String sortDirection) {
        return ImmutableList.of((Object)SortBuilders.fieldSort((String)sortProperty).order(SortOrder.valueOf((String)sortDirection.toUpperCase())));
    }
}

