/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.method.CleanupMethod;
import org.sonatype.nexus.cleanup.service.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.service.CleanupService;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
public class CleanupServiceImpl
extends ComponentSupport
implements CleanupService {
    public static final String CLEANUP_ATTRIBUTES_KEY = "cleanup";
    public static final String CLEANUP_NAME_KEY = "policyName";
    private final RepositoryManager repositoryManager;
    private final CleanupComponentBrowse browseService;
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final CleanupMethod cleanupMethod;
    private final GroupType groupType;

    @Inject
    public CleanupServiceImpl(RepositoryManager repositoryManager, CleanupComponentBrowse browseService, CleanupPolicyStorage cleanupPolicyStorage, CleanupMethod cleanupMethod, GroupType groupType) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.browseService = (CleanupComponentBrowse)Preconditions.checkNotNull((Object)browseService);
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.cleanupMethod = (CleanupMethod)Preconditions.checkNotNull((Object)cleanupMethod);
        this.groupType = (GroupType)Preconditions.checkNotNull((Object)groupType);
    }

    @Override
    public void cleanup(BooleanSupplier cancelledCheck) {
        AtomicLong totalDeletedCount = new AtomicLong(0L);
        this.repositoryManager.browse().forEach(repository -> {
            if (!cancelledCheck.getAsBoolean() && !repository.getType().equals((Object)this.groupType)) {
                totalDeletedCount.addAndGet(this.cleanup((Repository)repository, cancelledCheck));
            }
        });
        this.log.info("{} components cleaned up across all repositories", (Object)totalDeletedCount.get());
    }

    private Long cleanup(Repository repository, BooleanSupplier cancelledCheck) {
        AtomicLong deleted = new AtomicLong(0L);
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            this.findPolicy(repository).ifPresent(p -> {
                deleted.addAndGet(this.deleteByPolicy(repository, (CleanupPolicy)((Object)p), cancelledCheck));
                this.log.info("{} components cleaned up for repository {}", (Object)deleted, (Object)repository.getName());
            });
            Long l = deleted.get();
            return l;
        }
        finally {
            UnitOfWork.end();
        }
    }

    protected Long deleteByPolicy(Repository repository, CleanupPolicy policy, BooleanSupplier cancelledCheck) {
        this.log.info("Deleting components in repository {} using policy {}", (Object)repository.getName(), (Object)policy.getName());
        if (!policy.getCriteria().isEmpty()) {
            Iterable<EntityId> componentsToDelete = this.browseService.browse(policy, repository);
            return this.cleanupMethod.run(repository, componentsToDelete, cancelledCheck);
        }
        this.log.info("Policy {} has no criteria and will therefore be ignored (i.e. no components will be deleted)", (Object)policy.getName());
        return 0L;
    }

    private Optional<CleanupPolicy> findPolicy(Repository repository) {
        Map attributes = repository.getConfiguration().getAttributes();
        if (attributes != null && attributes.containsKey(CLEANUP_ATTRIBUTES_KEY)) {
            String policyName = (String)((Map)attributes.get(CLEANUP_ATTRIBUTES_KEY)).get(CLEANUP_NAME_KEY);
            this.log.debug("Cleanup policy '{}' found for repository {}", (Object)policyName, (Object)repository.getName());
            return Optional.ofNullable(this.cleanupPolicyStorage.get(policyName));
        }
        this.log.debug("No cleanup policy found for repository {}", (Object)repository.getName());
        return Optional.empty();
    }
}

