/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.storage.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyCreatedEvent;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyUpdatedEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class OrientCleanupPolicyEntityAdapter
extends IterableEntityAdapter<CleanupPolicy> {
    private static final String DB_CLASS = new OClassNameBuilder().type("cleanup").build();
    private static final String MAX_NAME_LENGTH = "255";
    private static final String P_NAME = "name";
    private static final String P_NOTES = "notes";
    private static final String P_FORMAT = "format";
    private static final String P_MODE = "mode";
    private static final String P_CRITERIA = "criteria";
    private static final String I_NAME = new OIndexNameBuilder().type(DB_CLASS).property("name").build();
    private static final String I_FORMAT = new OIndexNameBuilder().type(DB_CLASS).property("format").build();
    private static final String BROWSE_BY_FORMAT_WHERE_CLAUSE = String.format(" WHERE (format = :format OR format = \"%s\")", "ALL_FORMATS");

    public OrientCleanupPolicyEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_NAME, OType.STRING).setMandatory(true).setMax(MAX_NAME_LENGTH).setNotNull(true);
        type.createProperty(P_NOTES, OType.STRING).setMandatory(false).setNotNull(false);
        type.createProperty(P_FORMAT, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_MODE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_CRITERIA, OType.EMBEDDEDMAP).setMandatory(true).setNotNull(true);
        type.createIndex(I_NAME, OClass.INDEX_TYPE.UNIQUE, new String[]{P_NAME});
        type.createIndex(I_FORMAT, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_FORMAT});
    }

    protected CleanupPolicy newEntity() {
        return new CleanupPolicy();
    }

    protected void readFields(ODocument document, CleanupPolicy entity) {
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setNotes((String)document.field(P_NOTES, OType.STRING));
        entity.setFormat((String)document.field(P_FORMAT, OType.STRING));
        entity.setMode((String)document.field(P_MODE, OType.STRING));
        entity.setCriteria((Map)document.field(P_CRITERIA, OType.EMBEDDEDMAP));
    }

    protected void writeFields(ODocument document, CleanupPolicy entity) {
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_NOTES, (Object)entity.getNotes());
        document.field(P_FORMAT, (Object)entity.getFormat());
        document.field(P_MODE, (Object)entity.getMode());
        document.field(P_CRITERIA, entity.getCriteria());
    }

    @Nullable
    private ODocument findDocument(ODatabaseDocumentTx db, String id) {
        ORID rid = this.getRecordIdObfuscator().decode(this.getSchemaType(), id);
        return (ODocument)db.getRecord((OIdentifiable)rid);
    }

    public CleanupPolicy get(ODatabaseDocumentTx db, String name) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)name);
        String whereClause = " WHERE (name = :name) LIMIT 1";
        Iterable<ODocument> result = this.buildAndRunQuery(db, whereClause, (Map<String, String>)ImmutableMap.of((Object)P_NAME, (Object)name));
        Iterable policies = this.transform(result);
        return (CleanupPolicy)((Object)Iterables.getFirst((Iterable)policies, null));
    }

    public boolean exists(ODatabaseDocumentTx db, String name) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)name);
        ImmutableMap parameters = ImmutableMap.of((Object)P_NAME, (Object)name.toUpperCase());
        StringBuilder query = new StringBuilder("SELECT COUNT(*) FROM " + DB_CLASS + " WHERE (name.toUpperCase() = :name)");
        this.log.debug("Counting {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        List result = (List)db.command((OCommandRequest)new OCommandSQL(query.toString())).execute(new Object[]{parameters});
        return (Long)((ODocument)result.get(0)).field("COUNT") != 0L;
    }

    public Iterable<CleanupPolicy> browseByFormat(ODatabaseDocumentTx db, String format) {
        Preconditions.checkNotNull((Object)format);
        Iterable<ODocument> result = this.buildAndRunQuery(db, BROWSE_BY_FORMAT_WHERE_CLAUSE, (Map<String, String>)ImmutableMap.of((Object)P_FORMAT, (Object)format));
        return this.transform(result);
    }

    private Iterable<ODocument> buildAndRunQuery(ODatabaseDocumentTx db, String whereClause, Map<String, String> parameters) {
        StringBuilder query = new StringBuilder("SELECT FROM " + DB_CLASS + whereClause);
        this.log.debug("Finding {}s with query: {}, parameters: {}", new Object[]{this.getTypeName(), query, parameters});
        return (Iterable)db.command((OCommandRequest)new OCommandSQL(query.toString())).execute(new Object[]{parameters});
    }

    public boolean sendEvents() {
        return true;
    }

    @Nullable
    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        switch (eventKind) {
            case CREATE: {
                return new CleanupPolicyCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new CleanupPolicyUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new CleanupPolicyDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

