/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.storage.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.cleanup.internal.storage.orient.OrientCleanupPolicyEntityAdapter;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientCleanupPolicyStorage
extends StateGuardLifecycleSupport
implements CleanupPolicyStorage {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientCleanupPolicyEntityAdapter entityAdapter;

    @Inject
    public OrientCleanupPolicyStorage(@Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientCleanupPolicyEntityAdapter entityAdapter) {
        this.databaseInstance = databaseInstance;
        this.entityAdapter = entityAdapter;
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public CleanupPolicy add(CleanupPolicy item) {
        return (CleanupPolicy)((Object)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> (CleanupPolicy)this.entityAdapter.readEntity(this.entityAdapter.addEntity(db, (Entity)item))));
    }

    @Override
    @Guarded(by={"STARTED"})
    public CleanupPolicy update(CleanupPolicy cleanupPolicy) {
        return (CleanupPolicy)((Object)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> (CleanupPolicy)this.entityAdapter.readEntity(this.entityAdapter.editEntity(db, (Entity)cleanupPolicy))));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void remove(CleanupPolicy cleanupPolicy) {
        Preconditions.checkNotNull((Object)((Object)cleanupPolicy));
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntity(db, (Entity)cleanupPolicy));
    }

    @Override
    @Guarded(by={"STARTED"})
    public CleanupPolicy get(String cleanupPolicyName) {
        return (CleanupPolicy)((Object)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.get(db, cleanupPolicyName)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<CleanupPolicy> getAll() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean exists(String cleanupPolicyName) {
        return (Boolean)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.exists(db, cleanupPolicyName));
    }

    @Override
    public List<CleanupPolicy> getAllByFormat(String format) {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf(this.entityAdapter.browseByFormat(db, format)));
    }
}

