/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class CleanupBootService
extends LifecycleSupport {
    @VisibleForTesting
    static final String TASK_NAME = "Cleanup service";
    private final TaskScheduler taskScheduler;

    @Inject
    public CleanupBootService(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() {
        this.createCleanupTask();
    }

    private void createCleanupTask() {
        if (!this.doesTaskExist()) {
            TaskConfiguration taskConfig = this.taskScheduler.createTaskConfigurationInstance("repository.cleanup");
            taskConfig.setName(TASK_NAME);
            try {
                Cron run1amEveryDay = this.taskScheduler.getScheduleFactory().cron(new Date(), "0 0 1 * * ?");
                this.taskScheduler.scheduleTask(taskConfig, (Schedule)run1amEveryDay);
            }
            catch (RuntimeException e) {
                this.log.error("Problem scheduling cleanup task", (Throwable)e);
            }
        }
    }

    private boolean doesTaskExist() {
        return this.taskScheduler.listsTasks().stream().anyMatch(info -> "repository.cleanup".equals(info.getConfiguration().getTypeId()));
    }
}

