/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.storage;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.nexus.cleanup.config.CleanupPolicyConfiguration;
import org.sonatype.nexus.cleanup.service.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyPreviewXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyXO;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.extdirect.model.StoreLoadParameters;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.QueryOptions;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.DefaultComponentXO;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@DirectAction(action={"cleanup_CleanupPolicy"})
public class CleanupPolicyComponent
extends DirectComponentSupport {
    private static final BiFunction<Component, String, ComponentXO> COMPONENT_CONVERTER = (component, repositoryName) -> {
        DefaultComponentXO defaultComponentXO = new DefaultComponentXO();
        defaultComponentXO.setRepository(repositoryName);
        defaultComponentXO.setGroup(component.group());
        defaultComponentXO.setName(component.name());
        defaultComponentXO.setVersion(component.version());
        defaultComponentXO.setFormat(component.format());
        return defaultComponentXO;
    };
    private final ObjectMapper mapper = new ObjectMapper();
    private static final List<CleanupPolicyXO> NONE_POLICY_LIST = Collections.singletonList(CleanupPolicyXO.fromCleanupPolicy(CleanupPolicy.NONE_POLICY, Integer.MAX_VALUE));
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final CleanupComponentBrowse cleanupComponentBrowse;
    private final RepositoryManager repositoryManager;
    private final Map<String, CleanupPolicyConfiguration> cleanupPolicyConfiguration;
    private final CleanupPolicyConfiguration defaultCleanupPolicyConfiguration;

    @Inject
    public CleanupPolicyComponent(CleanupPolicyStorage cleanupPolicyStorage, CleanupComponentBrowse cleanupComponentBrowse, RepositoryManager repositoryManager, Map<String, CleanupPolicyConfiguration> cleanupPolicyConfiguration) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.cleanupComponentBrowse = (CleanupComponentBrowse)Preconditions.checkNotNull((Object)cleanupComponentBrowse);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.cleanupPolicyConfiguration = (Map)Preconditions.checkNotNull(cleanupPolicyConfiguration);
        this.defaultCleanupPolicyConfiguration = (CleanupPolicyConfiguration)Preconditions.checkNotNull((Object)cleanupPolicyConfiguration.get("default"));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:repository-admin"})
    public List<CleanupPolicyXO> readByFormat(StoreLoadParameters parameters) {
        return Optional.ofNullable(parameters.getFilter("format")).map(this::getAllByFormat).map(this::prependNonePolicy).orElse(NONE_POLICY_LIST);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:*"})
    public List<CleanupPolicyXO> readAll() {
        return this.cleanupPolicyStorage.getAll().stream().map(CleanupPolicyXO::fromCleanupPolicy).collect(Collectors.toList());
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate(groups={Create.class, Default.class})
    public CleanupPolicyXO create(@NotNull @Valid CleanupPolicyXO cleanupPolicyXO) {
        return CleanupPolicyXO.fromCleanupPolicy(this.cleanupPolicyStorage.add(CleanupPolicyXO.toCleanupPolicy(cleanupPolicyXO)));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate(groups={Update.class, Default.class})
    public CleanupPolicyXO update(@NotNull @Valid CleanupPolicyXO cleanupPolicyXO) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(cleanupPolicyXO.getName());
        return CleanupPolicyXO.fromCleanupPolicy(this.cleanupPolicyStorage.update(CleanupPolicyXO.mergeIntoCleanupPolicy(cleanupPolicyXO, cleanupPolicy)));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate
    public void remove(@NotEmpty String name) {
        this.cleanupPolicyStorage.remove(this.cleanupPolicyStorage.get(name));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate
    public Map<String, Map<String, Boolean>> getApplicableFields(List<String> fields) {
        HashMap<String, Map<String, Boolean>> applicability = new HashMap<String, Map<String, Boolean>>();
        for (Map.Entry<String, CleanupPolicyConfiguration> config : this.cleanupPolicyConfiguration.entrySet()) {
            String format = config.getKey();
            Map fieldApplicability = fields.stream().collect(Collectors.toMap(Function.identity(), f -> this.isFieldApplicable(format, (String)f)));
            applicability.put(format, fieldApplicability);
        }
        return applicability;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @Validate
    public Map<String, Object> usage(String cleanupPolicyName) {
        return ImmutableMap.of((Object)"repositoryCount", (Object)this.repositoryCount(cleanupPolicyName));
    }

    private boolean isFieldApplicable(@NotEmpty String format, String field) {
        CleanupPolicyConfiguration config = this.cleanupPolicyConfiguration.get(format);
        if (!config.getConfiguration().containsKey(field)) {
            return this.defaultCleanupPolicyConfiguration.getConfiguration().get(field);
        }
        return config.getConfiguration().get(field);
    }

    @Nullable
    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public PagedResponse<ComponentXO> previewCleanup(StoreLoadParameters parameters) throws IOException {
        String policy = parameters.getFilter("cleanupPolicy");
        String filter = parameters.getFilter("filter");
        if (policy == null || parameters.getSort() == null) {
            return null;
        }
        StoreLoadParameters.Sort sort = (StoreLoadParameters.Sort)parameters.getSort().get(0);
        QueryOptions queryOptions = new QueryOptions(filter, sort.getProperty(), sort.getDirection(), parameters.getStart(), parameters.getLimit());
        CleanupPolicyPreviewXO previewXO = (CleanupPolicyPreviewXO)this.mapper.readValue(policy, CleanupPolicyPreviewXO.class);
        Repository repository = this.repositoryManager.get(previewXO.getRepositoryName());
        if (repository == null) {
            return null;
        }
        return this.getSearchResults(previewXO, repository, queryOptions);
    }

    private List<CleanupPolicyXO> getAllByFormat(String format) {
        return this.cleanupPolicyStorage.getAllByFormat(format).stream().map(CleanupPolicyXO::fromCleanupPolicy).collect(Collectors.toList());
    }

    private List<CleanupPolicyXO> prependNonePolicy(List<CleanupPolicyXO> policyList) {
        return Stream.concat(NONE_POLICY_LIST.stream(), policyList.stream()).collect(Collectors.toList());
    }

    private PagedResponse<ComponentXO> getSearchResults(CleanupPolicyPreviewXO previewXO, Repository repository, QueryOptions queryOptions) {
        CleanupPolicy cleanupPolicy = CleanupPolicyPreviewXO.toCleanupPolicy(previewXO);
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            PagedResponse<ComponentXO> pagedResponse = this.searchForComponents(repository, cleanupPolicy, queryOptions);
            return pagedResponse;
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Transactional
    protected PagedResponse<ComponentXO> searchForComponents(Repository repository, CleanupPolicy cleanupPolicy, QueryOptions queryOptions) {
        PagedResponse<Component> components = this.cleanupComponentBrowse.browseByPage(cleanupPolicy, repository, queryOptions);
        List componentXOS = ((Collection)components.getData()).stream().map(item -> COMPONENT_CONVERTER.apply((Component)item, repository.getName())).collect(Collectors.toList());
        return new PagedResponse(components.getTotal(), componentXOS);
    }

    private long repositoryCount(String cleanupPolicyName) {
        return this.repositoryManager.browseForCleanupPolicy(cleanupPolicyName).count();
    }
}

