/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.storage.event;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.event.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Singleton
@Named
public class CleanupPolicyEventHandler
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryManager repositoryManager;

    @Inject
    public CleanupPolicyEventHandler(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(CleanupPolicyDeletedEvent event) {
        if (this.shouldProcess((EntityEvent)event)) {
            CleanupPolicy cleanupPolicy = event.getCleanupPolicy();
            this.repositoryManager.browseForCleanupPolicy(cleanupPolicy.getName()).forEach(repository -> this.remove(repository.getConfiguration().copy(), cleanupPolicy));
        }
    }

    private void remove(Configuration configuration, CleanupPolicy cleanupPolicy) {
        Map attributes = configuration.getAttributes();
        attributes.remove("cleanup");
        try {
            this.repositoryManager.update(configuration);
            this.log.info("Removed Cleanup Policy {} from Repository {}", (Object)cleanupPolicy.getName(), (Object)configuration.getRepositoryName());
        }
        catch (Exception e) {
            this.log.error("Unable to remove Cleanup Policy {} from Repository {}", new Object[]{cleanupPolicy.getName(), configuration.getRepositoryName(), e});
            throw new RuntimeException(e);
        }
    }

    private boolean shouldProcess(EntityEvent event) {
        Preconditions.checkNotNull((Object)event);
        return event.isLocal();
    }
}

