/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.install4j.slf4j;

import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.screens.Screen;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class Install4jLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static final String CONFIGURATION_FILE = "install4jlogger.properties";
    private static final String CONFIGURATION_PREFIX = Install4jLogger.class.getPackage().getName() + ".";
    public static final int LEVEL_TRACE = 0;
    public static final int LEVEL_DEBUG = 10;
    public static final int LEVEL_INFO = 20;
    public static final int LEVEL_WARN = 30;
    public static final int LEVEL_ERROR = 40;
    public static final int LEVEL_ALL = -10;
    public static final int LEVEL_OFF = 50;
    private static final Properties configuration = new Properties();
    private static boolean showLogName = true;
    private static boolean showLevel = false;
    protected int currentLogLevel = 20;
    private Class type;
    private boolean screenOrAction = false;

    private static String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? configuration.getProperty(name) : prop;
    }

    private static boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = Install4jLogger.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    Install4jLogger(String name) {
        this.name = name;
        this.type = this.loadType();
        if (this.type != null) {
            this.screenOrAction = Screen.class.isAssignableFrom(this.type) || Action.class.isAssignableFrom(this.type);
        }
        String level = Install4jLogger.getStringProperty(CONFIGURATION_PREFIX + "logger." + name);
        int i = name.lastIndexOf(".");
        while (null == level && i > -1) {
            name = name.substring(0, i);
            level = Install4jLogger.getStringProperty(CONFIGURATION_PREFIX + "logger." + name);
            i = name.lastIndexOf(".");
        }
        if (null == level) {
            level = Install4jLogger.getStringProperty(CONFIGURATION_PREFIX + "level");
        }
        if ("all".equalsIgnoreCase(level)) {
            this.currentLogLevel = -10;
        } else if ("trace".equalsIgnoreCase(level)) {
            this.currentLogLevel = 0;
        } else if ("debug".equalsIgnoreCase(level)) {
            this.currentLogLevel = 10;
        } else if ("info".equalsIgnoreCase(level)) {
            this.currentLogLevel = 20;
        } else if ("warn".equalsIgnoreCase(level)) {
            this.currentLogLevel = 30;
        } else if ("error".equalsIgnoreCase(level)) {
            this.currentLogLevel = 40;
        } else if ("off".equalsIgnoreCase(level)) {
            this.currentLogLevel = 50;
        }
    }

    private Class loadType() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.loadClass(this.name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void log(int level, String message, Throwable t) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        StringBuilder buff = new StringBuilder(32);
        if (showLevel) {
            switch (level) {
                case 0: {
                    buff.append("TRACE");
                    break;
                }
                case 10: {
                    buff.append("DEBUG");
                    break;
                }
                case 20: {
                    buff.append("INFO");
                    break;
                }
                case 30: {
                    buff.append("WARN");
                    break;
                }
                case 40: {
                    buff.append("ERROR");
                }
            }
            buff.append(' ');
        }
        if (this.type == null && showLogName) {
            buff.append(this.name).append(" - ");
        }
        buff.append(message);
        Class source = this.type;
        if (this.screenOrAction) {
            source = null;
        }
        if (level == 40) {
            Util.logError((Object)source, (String)buff.toString());
        } else {
            Util.logInfo((Object)source, (String)buff.toString());
        }
        if (t != null) {
            Util.log((Throwable)t);
        }
    }

    private void formatAndLog(int level, String format, Object arg1, Object arg2) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    private void formatAndLog(int level, String format, Object[] argArray) {
        if (!this.isLevelEnabled(level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])argArray);
        this.log(level, tp.getMessage(), tp.getThrowable());
    }

    protected boolean isLevelEnabled(int logLevel) {
        return logLevel >= this.currentLogLevel;
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(0);
    }

    public void trace(String msg) {
        this.log(0, msg, null);
    }

    public void trace(String format, Object param1) {
        this.formatAndLog(0, format, param1, null);
    }

    public void trace(String format, Object param1, Object param2) {
        this.formatAndLog(0, format, param1, param2);
    }

    public void trace(String format, Object[] argArray) {
        this.formatAndLog(0, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(0, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(10);
    }

    public void debug(String msg) {
        this.log(10, msg, null);
    }

    public void debug(String format, Object param1) {
        this.formatAndLog(10, format, param1, null);
    }

    public void debug(String format, Object param1, Object param2) {
        this.formatAndLog(10, format, param1, param2);
    }

    public void debug(String format, Object[] argArray) {
        this.formatAndLog(10, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(10, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(20);
    }

    public void info(String msg) {
        this.log(20, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(20, format, arg, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(20, format, arg1, arg2);
    }

    public void info(String format, Object[] argArray) {
        this.formatAndLog(20, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(20, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(30);
    }

    public void warn(String msg) {
        this.log(30, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(30, format, arg, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(30, format, arg1, arg2);
    }

    public void warn(String format, Object[] argArray) {
        this.formatAndLog(30, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(30, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(40);
    }

    public void error(String msg) {
        this.log(40, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(40, format, arg, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(40, format, arg1, arg2);
    }

    public void error(String format, Object[] argArray) {
        this.formatAndLog(40, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(40, msg, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
                if (threadCL != null) {
                    return threadCL.getResource(Install4jLogger.CONFIGURATION_FILE);
                }
                return ClassLoader.getSystemResource(Install4jLogger.CONFIGURATION_FILE);
            }
        });
        if (url != null) {
            try {
                Util.logInfo(null, (String)("Reading install4jlogger.properties: " + url));
                InputStream input = url.openStream();
                try {
                    configuration.load(input);
                    Util.logInfo(null, (String)("Configuration: " + configuration));
                }
                finally {
                    input.close();
                }
            }
            catch (IOException e) {
                Util.logError(null, (String)"Failed to load: install4jlogger.properties");
                Util.log((Throwable)e);
            }
        } else {
            Util.logError(null, (String)"Missing: install4jlogger.properties");
        }
        showLogName = Install4jLogger.getBooleanProperty(CONFIGURATION_PREFIX + "showLogName", showLogName);
        Util.logInfo(null, (String)("Show log-name: " + showLogName));
        showLevel = Install4jLogger.getBooleanProperty(CONFIGURATION_PREFIX + "showLevel", showLevel);
        Util.logInfo(null, (String)("Show level: " + showLevel));
    }
}

