/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * RutAuth Application strings
 *
 * @since 3.14
 */
Ext.define('NX.rutauth.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  /*
   * Note: Symbols follow the following naming convention:
   * <Class>_<Name>_<Component or Attribute>
   */

  keys: {
    Rut_Confirmation_Title: 'Please confirm',
    Rut_Confirmation_Html: '<p>{0}<br/><br/>Your credentials were verified using your Remote User Token. Proceed?</p>',
    Rut_Message_Default: 'This action required validation of your credentials.'
  }
}, function(obj) {
  NX.I18n.register(obj);
});
