/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Application strings
 *
 * @since 3.0
 */
Ext.define('NX.proui.app.PluginStrings', {
  '@aggregate_priority': 90,

  singleton: true,
  requires: [
    'NX.I18n'
  ],

  /*
   * Note: Symbols follow the following naming convention:
   * <Class>_<Name>_<Component or Attribute>
   */

  keys: {
    // Admin -> Security -> Atlassian Crowd
    Crowd_Text: 'Atlassian Crowd',
    Crowd_Description: 'Manage Atlassian Crowd configuration',
    Crowd_CrowdSettings_Update_Error: 'You do not have permission to configure Atlassian Crowd',
    Crowd_CrowdSettings_Update_Success: 'Atlassian Crowd settings $action',
    Crowd_CrowdSettings_Html: '<p>Application can be configured to use <a href="https://www.atlassian.com/software/crowd" target="_blank">Atlassian Crowd</a> for user database and authentication.</p>',
    Crowd_CrowdSettings_Enable_FieldLabel: 'Enable Crowd',
    Crowd_CrowdSettings_Activate_FieldLabel: 'Enable Crowd Realm for authentication',
    Crowd_CrowdSettings_Activate_HelpText: 'To control ordering, go to the <a href="#admin/security/realms">Realms</a> page.',
    Crowd_CrowdSettings_URL_FieldLabel: 'Crowd server URL',
    Crowd_CrowdSettings_URL_HelpText: 'For example: http://localhost:8095/crowd',
    Crowd_CrowdSettings_Name_FieldLabel: 'Crowd application name',
    Crowd_CrowdSettings_Password_FieldLabel: 'Crowd application password',
    Crowd_CrowdSettings_Request_FieldLabel: 'Connection timeout',
    Crowd_CrowdSettings_Request_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    Crowd_CrowdSettings_VerifyConnection_Text: 'Verify connection',
    Crowd_CrowdSettings_Verified_Success: 'Connection to Crowd server verified: {0}',
    Crowd_CrowdSettings_ClearCache_Text: 'Clear cache',
    Crowd_CrowdSettings_ClearCache_Success: 'Crowd cache has been cleared',

    // Admin -> Security -> User Token
    UserToken_Text: 'User Tokens',
    UserToken_Description: 'Manage user token configuration',
    UserTokenSettings_Update_Error: 'You do not have permission to configure user token',
    UserTokenSettings_Update_Success: 'User Token settings $action',
    UserTokenSettings_Html: '<p>The user token feature allows users to authenticate securely ' +
    'without typical user credentials such as those used by LDAP or Crowd.</p>' +
    '<p>User tokens generated for this server are only valid for use on this server. Once enabled, users can access ' +
    'their user token from <a href="#user/usertoken">user mode</a>.</p>',
    UserTokenSettings_Enable_FieldLabel: 'Enable user tokens',
    UserTokenSettings_Require_FieldLabel: 'Require user tokens for repository authentication',
    UserTokenSettings_Require_HelpText: 'This does not affect UI access',
    UserTokenSettings_Reset_Title: 'Reset user tokens',
    UserTokenSettings_Reset_Html: '<p>Reset will invalidate <b>ALL</b> existing user tokens and force new tokens to be created the next time they are accessed.</p>',
    UserTokenSettings_ResetAll_Button: 'Reset all user tokens',
    UserToken_Authentication_Validation: '{0} user tokens requires validation of your credentials.',
    UserToken_ResetAll_Success: 'All user tokens have been reset',
    UserToken_Reset_Success: 'Your user token has been reset',
    UserToken_ResetById_Message: 'User token of {0} has been reset',

    // Admin -> Security -> Users -> User Token -> Reset Token
    UserToken_UserTokenUser_Title: 'User Token',
    UserToken_UserTokenUser_ResetToken_Title: 'Reset user token',
    UserToken_UserTokenUser_ResetToken_Html: '<p>Resetting a user’s token will invalidate their current token and force a new token to be created the next time it is accessed by the user.</p>',
    UserToken_UserTokenUser_ResetToken_Button: 'Reset user token',

    // User -> User Token
    UserToken_Text: 'User Token',
    UserToken_Description: 'Access Nexus Repository Manager without the use of passwords',
    UserToken_UserTokenCurrent_Access_Title: 'Access your token',
    UserToken_UserTokenCurrent_Access_Html: 'A new user token will be created the first time it is accessed.',
    UserToken_UserTokenCurrent_Access_Button: 'Access user token',
    UserToken_UserTokenCurrent_Reset_Title: 'Reset your token',
    UserToken_UserTokenCurrent_Reset_Html: 'Resetting your user token will invalidate the current token and force a new token to be created the next time it is accessed.',
    UserToken_UserTokenCurrent_Reset_Button: 'Reset user token',

    // User -> User Token -> Access Token
    UserToken_UserTokenDetails_Title: 'User Token',
    UserToken_UserTokenDetails_Html1: 'User tokens are a combination of a name and password codes. <strong>Keep these codes secret.</strong>',
    UserToken_UserTokenDetails_Html2: '<p>Your user token is</p>',
    UserToken_UserTokenDetails_Html3: '<p>Use the following in your Maven settings.xml:</p>',
    UserToken_UserTokenDetails_Html4: '<p>Use the following for a base64 representation of "user:password":</p>',
    UserToken_UserTokenDetails_AutoClose_Html: 'This window will automatically close after one minute.',
    UserToken_UserTokenDetails_AutoClosing_Message: 'Automatically closing user token details due to timeout',

    //Nexus Lifecycle -> Server
    Clm_ClmSettings_Permission_Error: 'You do not have permission to configure IQ Server',
    Clm_Text: 'Server',
    Clm_Description: 'Manage IQ Server configuration',
    Clm_Connection_Success: 'Connection to IQ Server verified: {0}',
    Clm_Dashboard_Title: 'Dashboard',
    Clm_Dashboard_Description : 'Open IQ Server Dashboard',
    ClmSettings_Html: '<p><a href="http://www.sonatype.com/nexus/product-overview/nexus-lifecycle" target="_blank">IQ Server</a> ' +
    'can evaluate application and organization policies.</p>' +
    '<p>To enable this feature configure the IQ Server URL, username and password.</p>',

    Clm_SettingsTestResults_Title: 'Applications',
    Clm_SettingsTestResults_EmptyText: 'No applications found',
    Clm_SettingsTestResults_Id_Header: 'Id',
    Clm_SettingsTestResults_Name_Header: 'Name',

    ClmSettings_Enable_FieldLabel: 'Enable IQ Server',
    ClmSettings_Enable_HelpText: 'Whether to use IQ Server',
    ClmSettings_URL_FieldLabel: 'IQ Server URL',
    ClmSettings_URL_HelpText: 'The address of your IQ Server',
    ClmSettings_URL_EmptyText: 'enter a URL',
    ClmSettings_AuthenticationType_FieldLabel: 'Authentication Method',
    ClmSettings_AuthenticationType_Pki: 'PKI Authentication',
    ClmSettings_AuthenticationType_User: 'User Authentication',
    ClmSettings_Username_FieldLabel: 'Username',
    ClmSettings_Username_HelpText: 'User with access to IQ Server',
    ClmSettings_Username_EmptyText: 'enter a name',
    ClmSettings_Password_FieldLabel: 'Password',
    ClmSettings_Password_HelpText: 'Credentials for the IQ Server User',
    ClmSettings_Password_EmptyText: 'enter a password',
    ClmSettings_ConnectionTimeout_FieldLabel: 'Connection Timeout',
    ClmSettings_ConnectionTimeout_HelpText: 'Seconds to wait for activity before stopping and retrying the connection. Leave blank to use the globally defined HTTP timeout.',
    ClmSettings_ConnectionTimeout_EmptyText: 'enter a timeout',
    ClmSettings_Properties_FieldLabel: 'Properties',
    ClmSettings_Properties_HelpText: 'Additional properties to configure for IQ Server',
    ClmSettings_Properties_EmptyText: 'enter properties',
    ClmSettings_Properties_Verify_Button: 'Verify connection',

    // Healthcheck results
    HealthCheckInfo_Security_Alerts_Label: 'Security',
    HealthCheckInfo_License_Threat_Label: 'License ',
    HealthCheckInfo_Tooltip: 'License and security data is only available with a paid license.',
    HealthCheckInfo_LoggedInOnly_Tooltip: 'The license and security data is only available once you have logged in.',
    HealthCheckInfo_NoPermission_Tooltip: 'You do not have permission to view the license and security data.',

    FirewallRepositoryColumn_Header: 'IQ Policy Violations',
    FirewallRepositoryColumn_Loading: 'Loading&hellip;',
    FirewallRepositoryColumn_NoViolations: 'No violations',

    DatabaseQuorumReset_Title: 'Cluster Reset',
    DatabaseQuorumResetConfirm_Resetting: 'Resetting Cluster Size',
    DatabaseQuorumReset_Description: 'Take your cluster down to a single node',
    DatabaseQuorumReset_ResetButton: 'Reset Database Quorum',
    DatabaseQuorumResetConfirm_Title: 'Confirm Cluster Reset',
    DatabaseQuorumResetConfirm_HelpText: 'Have you ensured that other nodes in the cluster are shut down? Resetting the quorum can result in corrupt data if other nodes are still online.',
    DatabaseQuorumResetConfirm_Fail: 'Failed to reset database cluster quorum setting!',
    DatabaseQuorumResetConfirm_GetLocalNode_Fail: 'Unable to detect which node you are currently connected to',
    DatabaseQuorumResetConfirm_LocalNodeNotKnown: 'Cannot reset database cluster quorum setting, the current node is unidentified',
    DatabaseQuorumResetConfirm_Success: 'The database cluster write quorum was reset to one node',
    DatabaseQuorumResetConfirm_Yes: 'Reset Quorum',
    DatabaseQuorumResetConfirm_No: '@Button_Cancel',

    // Tags
    ComponentTags_TagTitle: 'Component Tags',
    ComponentTags_NoTagsFound: 'No tags found',
    ComponentTags_ClickForDetails: 'Click row to view details in a new window',
    ComponentTags_TagNameHeader: 'Tag Name',
    ComponentTags_FirstCreatedHeader: 'First Created Time',
    ComponentTags_LastUpdatedHeader: 'Last Updated Time',

    Tags_Description: 'View created tags',
    Tags_Title: 'Tags',
    Tags_EmptyText: 'No tags found.',
    TagFeature_FindTaggedComponents_Button: 'Find Tagged Components',
    TagPanel_Attributes_Label: 'Attributes',
    TagPanel_FirstCreated_Label: 'First Created Time',
    TagPanel_LastUpdated_Label: 'Last Updated Time'
  }
}, function(obj) {
  NX.I18n.register(obj);
});
