/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Crowd controller.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.Crowd', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Messages',
    'NX.I18n'
  ],

  views: [
    'crowd.CrowdSettings'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getIconController().addIcons({
      'crowd-security-source': {
        file: 'crowd.png',
        variants: ['x16']
      }
    });

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/Security/Atlassian Crowd',
      text: NX.I18n.get('Crowd_Text'),
      description: NX.I18n.get('Crowd_Description'),
      view: { xtype: 'nx-proui-crowd-settings' },
      iconConfig: {
        file: 'crowd.png',
        variants: ['x16', 'x32']
      },
      visible: function () {
        return NX.Permissions.check('nexus:crowd:read');
      }
    }, me);

    me.listen({
      component: {
        'nx-proui-crowd-settings button[action=verify]': {
          click: me.verifyConnection
        },
        'nx-proui-crowd-settings button[action=clearCache]': {
          click: me.clearCache
        }
      }
    });
  },

  verifyConnection: function (button) {
    var form = button.up('form'),
        values = form.getForm().getFieldValues();

    form.getEl().mask('Checking connection to ' + values.url);

    NX.direct.crowd_Crowd.verifyConnection(values, function (response) {
      form.getEl().unmask();
      if (Ext.isDefined(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('Crowd_CrowdSettings_Verified_Success', values.url), type: 'success' });
      }
    });
  },

  clearCache: function (button) {
    var form = button.up('form');

    form.getEl().mask('Clearing cache...');

    NX.direct.crowd_Crowd.clearCache(function (response) {
      form.getEl().unmask();
      if (Ext.isDefined(response) && response.success) {
        NX.Messages.add({ text: NX.I18n.format('Crowd_CrowdSettings_ClearCache_Success'), type: 'success' });
      }
    });
  }

});
