/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Database Quorum Reset controller.
 *
 * @since 3.4
 */
Ext.define('NX.proui.controller.DatabaseQuorumReset', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.Permissions',
    'NX.Messages',
    'NX.I18n'
  ],
  views: [
    'database.DatabaseQuorumResetConfirm'
  ],

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.getApplication().getFeaturesController().registerFeature({
      mode: 'admin',
      path: '/System/Nodes/Cluster Reset',
      text: NX.I18n.get('DatabaseQuorumReset_Title'),
      description: NX.I18n.get('DatabaseQuorumReset_Description'),
      view: { xtype: 'nx-proui-database-quorum-reset' },
      visible: function () {
        return NX.Permissions.check('nexus:settings:update') && !NX.State.getValue('quorum', {})['quorumPresent'];
      }
    }, me);

    me.listen({
      component: {
        'nx-proui-database-quorum-reset button[action=resetQuorum]': {
          'click': me.resetQuorum
        }
      }
    });

    me.myNodeId = null;
    NX.direct.node_NodeAccess.nodes(function(response, event){
      if (Ext.isObject(response) && response.success) {
        response.data.forEach(function(nodeXO) {
          if (nodeXO.local) {
            me.myNodeId = nodeXO.name;
          }
        });
      }
      else if (event.xhr.status !== 0) {
        NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_GetLocalNode_Fail'), type: 'warning' });
      }
    });
  },

  /**
   *
   * @private
   */
  resetQuorum: function () {
    var me = this;

    if (me.myNodeId == null) {
      NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_LocalNodeNotKnown'), type: 'warning' });
    }
    else {
      NX.Dialogs.askConfirmation(NX.I18n.get('DatabaseQuorumResetConfirm_Title'),
          NX.I18n.format('DatabaseQuorumResetConfirm_HelpText'), function() {
            NX.direct.proui_Database.resetQuorum(me.myNodeId, function(response){
              if (Ext.isObject(response) && response.success) {
                NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_Success'), type: 'success' });
                NX.Bookmarks.navigateTo(NX.Bookmarks.fromToken('admin/system/nodes'));
              }
              else {
                NX.Messages.add({ text: NX.I18n.get('DatabaseQuorumResetConfirm_Fail'), type: 'warning' });
              }
            });
          }, {
            scope: me,
            buttonText: {
              yes: NX.I18n.get('DatabaseQuorumResetConfirm_Yes'),
              no: NX.I18n.get('DatabaseQuorumResetConfirm_No')
            }
          });
    }
  }
});
