/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Registers all feature groups for proui.
 *
 * @since 3.0
 */
Ext.define('NX.proui.controller.FeatureGroups', {
  extend: 'NX.app.Controller',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  init: function () {
    this.getApplication().getFeaturesController().registerFeature([
      {
        mode: 'admin',
        path: '/IQ',
        text: 'IQ Server',
        description: 'IQ Server integration',
        group: true,
        weight: 70,
        iconConfig: {
          file: 'three_tags.png',
          variants: ['x16', 'x32']
        }
      }
    ]);
  }

});
