/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext*/

/**
 * License warning controller, handles showing messages.
 *
 * @since 3.1
 */
Ext.define('NX.proui.controller.LicenseWarnings', {
  extend: 'NX.app.Controller',

  requires: [
    'NX.I18n',
    'NX.Permissions'
  ],
  refs: [
    {
      ref: 'licenseWarning',
      selector: '#nx-license-warning'
    }
  ],

  /**
   * The number of days before expiry that we should warn for.
   * @private
   */
  daysToWarn: 30,

  /**
   * @override
   */
  init: function () {
    var me = this;

    me.listen({
      controller: {
        '#State': {
          licensechanged: me.updateLicenseExpiryWarning
        },
        '#Permissions': {
          changed: me.updateLicenseExpiryWarning
        }
      }
    });
  },

  /**
   * Set a warning for license expiry based on the current state. 
   * @public
   */
  updateLicenseExpiryWarning: function () {
    var me = this,
        daysToExpiry = NX.State.getDaysToLicenseExpiry(),
        licenseWarning = me.getLicenseWarning();

    if (licenseWarning) {
      if (daysToExpiry != null) {
        //<if debug>
        me.logDebug('Checking for license warning');
        //</if>
        if(daysToExpiry < 0) {
          me.setLicenseWarning(NX.I18n.get('State_License_Expired'))
        }
        else if (daysToExpiry < me.daysToWarn) {
          me.setLicenseWarning(NX.I18n.format('State_License_Expiry', daysToExpiry));
        }
      }
      else {
        //<if debug>
        me.logDebug('Skipping check for license warning');
        //</if>
        licenseWarning.hide();
      }
    }
  },

  /**
   * Set the text for the license warning element.
   * @public
   * @param text
   */
  setLicenseWarning: function (text) {
    var me = this,
        licenseWarning = me.getLicenseWarning();
    licenseWarning.setTitle(text);
    licenseWarning.show();
  }

});
