/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tag Controller
 *
 * @since 3.14
 */
Ext.define('NX.proui.controller.Tags', {
  extend: 'NX.controller.Drilldown',
  requires: [
    'NX.Bookmarks',
    'NX.Permissions',
    'NX.I18n'
  ],
  masters: [
    'nx-proui-tags-list'
  ],
  models: [
    'Tag'
  ],
  stores: [
    'Tags'
  ],
  views: [
    'tags.TagFeature',
    'tags.TagList',
    'tags.TagPanel'
  ],
  refs: [
    { ref: 'feature', selector: 'nx-proui-tags-feature' },
    { ref: 'content', selector: 'nx-feature-content' },
    { ref: 'list', selector: 'nx-proui-tags-list' },
    { ref: 'settings', selector: 'nx-proui-tags-feature nx-proui-tag-panel' }
  ],

  permission: 'nexus:tags',

  /**
   * @override
   */
  init: function() {
    var me = this;

    me.features = {
      mode: 'browse',
      path: '/tags',
      text: NX.I18n.get('Tags_Title'),
      description: NX.I18n.get('Tags_Description'),
      view: {xtype: 'nx-proui-tags-feature'},
      iconCls: 'x-fa fa-tags',
      visible: function() {
        return NX.Permissions.check('nexus:tags:read');
      }
    };

    me.callParent();

    me.listen({
      controller: {
        '#Refresh': {
          refresh: me.loadStores
        }
      },
      store: {
        '#Tags': {
          load: me.reselect
        }
      },
      component: {
        'nx-proui-tags-feature button[action=search]': {
          click: me.searchByTag
        }
      }
    });
  },

  /**
   * @override
   */
  getDescription: function(model) {
    return model.get('id');
  },

  /**
   * @override
   */
  onSelection: function(list, model) {
    if (Ext.isDefined(model)) {
      this.getSettings().loadRecord(model);
    }
  },

  searchByTag: function() {
    var tagName = NX.Bookmarks.getBookmark().segments[1],
        searchUrl = '#browse/search/custom=' + encodeURIComponent('tags="' + tagName + '"');

    window.open(searchUrl, '_self');
  }
});
