/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags store.
 *
 * @since 3.14
 */
Ext.define('NX.proui.store.Tags', {
  extend: 'Ext.data.Store',
  model: 'NX.proui.model.Tag',

  proxy: {
    type: 'direct',

    api: {
      read: 'NX.direct.proui_TagList.readTags'
    },

    reader: {
      type: 'json',
      rootProperty: 'data',
      successProperty: 'success'
    }
  },

  autoLoad: false,

  sorters: { property: 'id', direction: 'ASC' }
});
