/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Crowd settings form.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.crowd.CrowdSettings', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-crowd-settings',
  requires: [
    'NX.Conditions',
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function () {
    var me = this;

    me.settingsForm = {
      xtype: 'nx-settingsform',
      settingsFormSuccessMessage: NX.I18n.get('Crowd_CrowdSettings_Update_Success'),
      api: {
        load: 'NX.direct.crowd_Crowd.read',
        submit: 'NX.direct.crowd_Crowd.update'
      },
      editableCondition: NX.Conditions.isPermitted('nexus:crowd:update'),
      editableMarker: NX.I18n.get('Crowd_CrowdSettings_Update_Error'),

      items: [
        {
          xtype: 'label',
          html: NX.I18n.get('Crowd_CrowdSettings_Html')
        },
        {
          xtype: 'checkbox',
          name: 'enabled',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Enable_FieldLabel')
        },
        {
          xtype: 'checkbox',
          name: 'realmActive',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Activate_FieldLabel'),
          helpText: NX.I18n.get('Crowd_CrowdSettings_Activate_HelpText')
        },
        {
          xtype: 'nx-url',
          name: 'url',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_URL_FieldLabel'),
          helpText: NX.I18n.get('Crowd_CrowdSettings_URL_HelpText')
        },
        {
          name: 'applicationName',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Name_FieldLabel'),
          inputAttrTpl: 'autocomplete="new-username"'
        },
        {
          xtype: 'nx-password',
          name: 'applicationPassword',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Password_FieldLabel'),
          inputAttrTpl: 'autocomplete="new-password"'
        },
        {
          xtype: 'numberfield',
          name: 'timeout',
          fieldLabel: NX.I18n.get('Crowd_CrowdSettings_Request_FieldLabel'),
          helpText: NX.I18n.get('Crowd_CrowdSettings_Request_HelpText'),
          allowBlank: true,
          allowDecimals: false,
          allowExponential: false,
          minValue: 1,
          maxValue: 3600
        }
      ]
    };

    me.callParent();

    me.down('nx-settingsform').getDockedItems('toolbar[dock="bottom"]')[0].add({
      xtype: 'button', text: NX.I18n.get('Crowd_CrowdSettings_VerifyConnection_Text'), formBind: true, action: 'verify'
    },
    {
      xtype: 'button',
      text: NX.I18n.get('Crowd_CrowdSettings_ClearCache_Text'),
      glyph: 'xf014@FontAwesome' /* fa-trash-o */,
      formBind: true,
      action: 'clearCache'
    }
    );
  }

});
