/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Tags list details panel.
 *
 * @since 3.14
 */
Ext.define('NX.proui.view.tags.ComponentTags', {
  extend: 'Ext.grid.Panel',
  alias: 'widget.nx-proui-tags-taglistdetails',
  requires: [
    'NX.I18n'
  ],

  manageHeight: false,

  store: 'ComponentTags',

  initComponent: function() {
    Ext.apply(this, {
      store: 'ComponentTags',

      // Prevent the store from automatically loading
      loadStore: Ext.emptyFn,

      allowDeselect: true,

      viewConfig: {
        emptyText: NX.I18n.get('ComponentTags_NoTagsFound'),
        deferEmptyText: false
      },

      columns: [
        {
          text: NX.I18n.get('ComponentTags_TagNameHeader'),
          dataIndex: 'id',
          renderer: Ext.htmlEncode,
          flex: 2.5
        },
        {
          text: NX.I18n.get('ComponentTags_FirstCreatedHeader'),
          dataIndex: 'firstCreatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        },
        {
          text: NX.I18n.get('ComponentTags_LastUpdatedHeader'),
          dataIndex: 'lastUpdatedTime',
          flex: 2.5,
          renderer: function (val) {
            return new Date(val).toLocaleString();
          }
        }
      ]
    });

    this.on('itemclick', function(dv, record) {
      var bookmark = Ext.create('NX.Bookmark');

      bookmark.applyToken('browse/tags');
      bookmark.appendSegments(record.id);
      NX.Bookmarks.navigateTo(bookmark);
    });

    this.callParent();
  }
});
