/*
 * Copyright (c) 2008-present Sonatype, Inc.
 *
 * All rights reserved. Includes the third-party code listed at http://links.sonatype.com/products/nexus/pro/attributions
 * Sonatype and Sonatype Nexus are trademarks of Sonatype, Inc. Apache Maven is a trademark of the Apache Foundation.
 * M2Eclipse is a trademark of the Eclipse Foundation. All other trademarks are the property of their respective owners.
 */
/*global Ext, NX*/

/**
 * Current user, usertoken settings form.
 *
 * @since 3.0
 */
Ext.define('NX.proui.view.usertoken.UserTokenCurrent', {
  extend: 'NX.view.SettingsPanel',
  alias: 'widget.nx-proui-usertoken-current',
  requires: [
    'NX.I18n'
  ],

  /**
   * @override
   */
  initComponent: function() {
    Ext.apply(this, {
      settingsForm: [
        {
          xtype: 'form',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('UserToken_UserTokenCurrent_Access_Title'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserToken_UserTokenCurrent_Access_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserToken_UserTokenCurrent_Access_Button'), action: 'access', ui: 'nx-primary', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        },
        {
          xtype: 'form',
          ui: 'nx-subsection',
          frame: true,
          title: NX.I18n.get('UserToken_UserTokenCurrent_Reset_Title'),

          items: [
            {
              xtype: 'label',
              html: NX.I18n.get('UserToken_UserTokenCurrent_Reset_Html')
            }
          ],

          buttonAlign: 'left',
          buttons: [
            { text: NX.I18n.get('UserToken_UserTokenCurrent_Reset_Button'), action: 'reset', glyph: 'xf023@FontAwesome' /* fa-lock */ }
          ]
        }
      ]
    });

    this.callParent();
  }

});
